/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.refactoring.refactor.impl;

import com.yakindu.base.expressions.expressions.ExpressionsFactory;
import com.yakindu.base.expressions.expressions.ReactionEffect;
import com.yakindu.base.expressions.expressions.ReactionTrigger;
import com.yakindu.base.types.Effect;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Trigger;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.stext.stext.EntryEvent;
import com.yakindu.sct.model.stext.stext.LocalReaction;
import com.yakindu.sct.model.stext.stext.StextFactory;
import com.yakindu.sct.refactoring.refactor.AbstractRefactoring;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class FoldIncomingActionsRefactoring
extends AbstractRefactoring<State> {
    @Override
    protected void internalExecute() {
        List<Expression> actionsToFold = this.getFoldableActions();
        this.addActionsToEntryReaction(actionsToFold);
    }

    @Override
    public boolean isExecutable() {
        return super.isExecutable() && this.atLeastOneActionIsFoldable() && this.noIncomingTransitionEntersCompositeWithEntryActions();
    }

    private boolean noIncomingTransitionEntersCompositeWithEntryActions() {
        return !this.helper.oneIncomingTransitionEntersCompositeWithEntryActions((State)this.getContextObject());
    }

    private boolean atLeastOneActionIsFoldable() {
        EList transitions = ((State)this.getContextObject()).getIncomingTransitions();
        return this.getLastFoldableAction(this.helper.getAllActions((List<Transition>)transitions), 0) != null;
    }

    private List<Expression> getFoldableActions() {
        Expression lastFoldableAction;
        EList transitions = ((State)this.getContextObject()).getIncomingTransitions();
        ArrayList<Expression> foldableActions = new ArrayList<Expression>();
        int indexFromBack = 0;
        while ((lastFoldableAction = this.getLastFoldableAction(this.helper.getAllActions((List<Transition>)transitions), indexFromBack)) != null) {
            foldableActions.add(0, lastFoldableAction);
            ++indexFromBack;
        }
        this.removeLastActions((EList<Transition>)transitions, indexFromBack);
        return foldableActions;
    }

    private void addActionsToEntryReaction(List<Expression> actionsToAdd) {
        if (actionsToAdd.isEmpty()) {
            return;
        }
        EList<Expression> actionsOriginal = this.helper.getFirstEntryActions((State)this.getContextObject());
        if (actionsOriginal == null) {
            actionsOriginal = this.createEntryBlock(actionsToAdd);
        } else {
            actionsOriginal.addAll(0, actionsToAdd);
        }
    }

    private EList<Expression> createEntryBlock(List<Expression> actionsToAdd) {
        LocalReaction newLocalReaction = StextFactory.eINSTANCE.createLocalReaction();
        ReactionTrigger newReactionTrigger = ExpressionsFactory.eINSTANCE.createReactionTrigger();
        EntryEvent entryEvent = StextFactory.eINSTANCE.createEntryEvent();
        ReactionEffect newReactionEffect = ExpressionsFactory.eINSTANCE.createReactionEffect();
        newLocalReaction.setTrigger((Trigger)newReactionTrigger);
        newReactionTrigger.getTriggers().add((Object)entryEvent);
        newReactionEffect.getActions().addAll(actionsToAdd);
        newLocalReaction.setEffect((Effect)newReactionEffect);
        Scope scope = (Scope)((State)this.getContextObject()).getScopes().get(0);
        scope.getReactions().add((Object)newLocalReaction);
        EList actionsOriginal = newReactionEffect.getActions();
        return actionsOriginal;
    }

    private void removeLastActions(EList<Transition> transitions, int number) {
        for (Transition transition : transitions) {
            List<Expression> actionsToRemove = this.getLastActions(transition, number);
            Effect effect = transition.getEffect();
            if (effect instanceof ReactionEffect && actionsToRemove.size() == ((ReactionEffect)effect).getActions().size()) {
                EcoreUtil.delete((EObject)effect, (boolean)true);
                continue;
            }
            for (Expression action : actionsToRemove) {
                EcoreUtil.delete((EObject)action);
            }
        }
    }

    private List<Expression> getLastActions(Transition transition, int number) {
        ArrayList<Expression> lastActions = new ArrayList<Expression>();
        Effect effect = transition.getEffect();
        if (effect instanceof ReactionEffect) {
            ReactionEffect reactionEffect = (ReactionEffect)effect;
            EList actions = reactionEffect.getActions();
            int i = 1;
            while (i <= number) {
                lastActions.add((Expression)actions.get(actions.size() - i));
                ++i;
            }
        }
        return lastActions;
    }

    private Expression getLastFoldableAction(List<List<Expression>> allActions, int indexFromBack) {
        Expression actionToCheck = null;
        for (List<Expression> actionList : allActions) {
            if (actionList.size() - 1 - indexFromBack < 0) {
                return null;
            }
            Expression lastAction = actionList.get(actionList.size() - 1 - indexFromBack);
            if (actionToCheck == null) {
                actionToCheck = lastAction;
                continue;
            }
            if (EcoreUtil.equals((EObject)actionToCheck, (EObject)lastAction)) continue;
            return null;
        }
        return actionToCheck;
    }

    @Override
    protected String getCommandLabel() {
        return "Fold Incoming Actions";
    }
}

