/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.refactoring.utils;

import com.yakindu.base.expressions.expressions.EventSpec;
import com.yakindu.base.expressions.expressions.ReactionEffect;
import com.yakindu.base.expressions.expressions.ReactionTrigger;
import com.yakindu.base.types.Effect;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Trigger;
import com.yakindu.sct.model.sgraph.CompositeElement;
import com.yakindu.sct.model.sgraph.Reaction;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.stext.stext.EntryEvent;
import com.yakindu.sct.model.stext.stext.ExitEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class RefactoringHelper {
    public List<List<Expression>> getAllActions(List<Transition> transitions) {
        ArrayList<List<Expression>> allActions = new ArrayList<List<Expression>>();
        for (Transition transition : transitions) {
            Effect effect = transition.getEffect();
            if (effect instanceof ReactionEffect) {
                ReactionEffect reactionEffect = (ReactionEffect)effect;
                allActions.add((List<Expression>)reactionEffect.getActions());
                continue;
            }
            allActions.add(Collections.emptyList());
        }
        return allActions;
    }

    public boolean hasEntryAction(State state) {
        EList<Expression> entryActions = this.getFirstEntryActions(state);
        return entryActions != null && !entryActions.isEmpty();
    }

    public boolean hasExitAction(State state) {
        EList<Expression> exitActions = this.getFirstExitActions(state);
        return exitActions != null && !exitActions.isEmpty();
    }

    public boolean oneOutgoingTransitionLeavesCompositeWithExitActions(State state) {
        HashSet<State> sourceParentStates = new HashSet<State>(this.getParentStates((Vertex)state));
        for (Transition transition : state.getOutgoingTransitions()) {
            Set<State> targetParentStates = this.getParentStates(transition.getTarget());
            HashSet<State> crossedStates = new HashSet<State>(sourceParentStates);
            crossedStates.removeAll(targetParentStates);
            for (State crossedCompositeState : crossedStates) {
                if (!this.hasExitAction(crossedCompositeState)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean oneIncomingTransitionEntersCompositeWithEntryActions(State state) {
        HashSet<State> targetParentStates = new HashSet<State>(this.getParentStates((Vertex)state));
        for (Transition transition : state.getIncomingTransitions()) {
            Set<State> sourceParentStates = this.getParentStates(transition.getSource());
            HashSet<State> crossedStates = new HashSet<State>(targetParentStates);
            crossedStates.removeAll(sourceParentStates);
            for (State crossedCompositeState : crossedStates) {
                if (!this.hasEntryAction(crossedCompositeState)) continue;
                return true;
            }
        }
        return false;
    }

    public EList<Expression> getFirstEntryActions(State state) {
        EList localReactions = state.getLocalReactions();
        for (Reaction reaction : localReactions) {
            Trigger trigger = reaction.getTrigger();
            if (!(trigger instanceof ReactionTrigger)) continue;
            ReactionTrigger reactionTrigger = (ReactionTrigger)trigger;
            EList triggers = reactionTrigger.getTriggers();
            for (EventSpec eventSpec : triggers) {
                if (!(eventSpec instanceof EntryEvent) || !(reaction.getEffect() instanceof ReactionEffect)) continue;
                return ((ReactionEffect)reaction.getEffect()).getActions();
            }
        }
        return null;
    }

    public EList<Expression> getFirstExitActions(State state) {
        EList localReactions = state.getLocalReactions();
        for (Reaction reaction : localReactions) {
            Trigger trigger = reaction.getTrigger();
            if (!(trigger instanceof ReactionTrigger)) continue;
            ReactionTrigger reactionTrigger = (ReactionTrigger)trigger;
            EList triggers = reactionTrigger.getTriggers();
            for (EventSpec eventSpec : triggers) {
                if (!(eventSpec instanceof ExitEvent) || !(reaction.getEffect() instanceof ReactionEffect)) continue;
                return ((ReactionEffect)reaction.getEffect()).getActions();
            }
        }
        return null;
    }

    public boolean hasAtLeastOneAction(Transition transition) {
        Effect effect = transition.getEffect();
        if (effect instanceof ReactionEffect) {
            ReactionEffect reactionEffect = (ReactionEffect)effect;
            EList actions = reactionEffect.getActions();
            return !actions.isEmpty();
        }
        return false;
    }

    public List<Expression> extractAllLocalActionsForEventType(State state, Class<? extends EventSpec> eventType) {
        ArrayList<Expression> resultActions = new ArrayList<Expression>();
        for (Reaction reaction : state.getLocalReactions()) {
            if (!(reaction.getEffect() instanceof ReactionEffect) || !(reaction.getTrigger() instanceof ReactionTrigger)) continue;
            resultActions.addAll(this.getReactionEffectActionsForEventType(reaction, eventType));
        }
        return resultActions;
    }

    protected List<Expression> getReactionEffectActionsForEventType(Reaction reaction, Class<? extends EventSpec> eventType) {
        EList triggers = ((ReactionTrigger)reaction.getTrigger()).getTriggers();
        if (this.containsAtLeastOneEventOfType((List<EventSpec>)triggers, eventType)) {
            return ((ReactionEffect)reaction.getEffect()).getActions();
        }
        return Collections.emptyList();
    }

    private Set<State> getParentStates(Vertex state) {
        HashSet<State> parentStates = new HashSet<State>();
        CompositeElement composite = state.getParentRegion().getComposite();
        if (composite instanceof State) {
            State parentState = (State)composite;
            parentStates.add(parentState);
            parentStates.addAll(this.getParentStates((Vertex)parentState));
        }
        return parentStates;
    }

    private void deleteAllEventsOfType(List<EventSpec> events, Class<? extends EventSpec> eventType) {
        for (EventSpec event : events) {
            if (!eventType.isAssignableFrom(event.getClass())) continue;
            EcoreUtil.remove((EObject)event);
        }
    }

    public void removeReactionsOfEventType(EList<Reaction> reactions, Class<? extends EventSpec> eventType) {
        for (Reaction reaction : reactions) {
            ArrayList<EventSpec> triggers = new ArrayList<EventSpec>((Collection<EventSpec>)((ReactionTrigger)reaction.getTrigger()).getTriggers());
            if (this.containsOnlyEventsOfType(triggers, eventType)) {
                EcoreUtil.remove((EObject)reaction);
                continue;
            }
            if (!this.containsAtLeastOneEventOfType(triggers, eventType)) continue;
            this.deleteAllEventsOfType(triggers, eventType);
        }
    }

    private boolean containsAtLeastOneEventOfType(List<EventSpec> events, Class<? extends EventSpec> eventType) {
        for (EventSpec event : events) {
            if (!eventType.isAssignableFrom(event.getClass())) continue;
            return true;
        }
        return false;
    }

    private boolean containsOnlyEventsOfType(List<EventSpec> events, Class<? extends EventSpec> eventType) {
        for (EventSpec event : events) {
            if (eventType.isAssignableFrom(event.getClass())) continue;
            return false;
        }
        return true;
    }

    public boolean haveAllAtLeastOneAction(EList<Transition> transitions) {
        if (transitions.isEmpty()) {
            return false;
        }
        for (Transition transition : transitions) {
            if (this.hasAtLeastOneAction(transition)) continue;
            return false;
        }
        return true;
    }

    public View getViewForSemanticElement(EObject semanticElement, Diagram diagram) {
        TreeIterator allContents = diagram.eAllContents();
        while (allContents.hasNext()) {
            View view;
            EObject next = (EObject)allContents.next();
            if (!(next instanceof View) || !EcoreUtil.equals((EObject)(view = (View)next).getElement(), (EObject)semanticElement)) continue;
            return view;
        }
        throw new IllegalArgumentException("No view found for semantic element " + String.valueOf(semanticElement));
    }
}

