/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.yet.core.protocol;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.yakindu.yet.core.YETEvent;
import com.yakindu.yet.core.config.IYETConfigParameters;
import com.yakindu.yet.core.format.YETParserException;
import com.yakindu.yet.core.format.YETWriter;
import com.yakindu.yet.core.format.YETWriterException;
import com.yakindu.yet.core.protocol.IYETMessageSender;
import com.yakindu.yet.core.protocol.YETAbstractMessagePort;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class YETTCPPort
extends YETAbstractMessagePort
implements IYETConfigParameters,
IYETMessageSender {
    private TCPServer server;
    @Inject
    @Named(value="YET_PROVIDER_TCP_PORT")
    protected Integer tcpPort;
    @Inject
    protected YETWriter writer;

    @Override
    public void start() throws Exception {
        super.start();
        if (this.server == null) {
            this.server = new TCPServer(this.tcpPort, s -> {
                try {
                    this.provide(this.parse((String)s));
                }
                catch (YETParserException e) {
                    e.printStackTrace();
                }
            });
            this.server.start();
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (!this.isRunning()) {
            this.server.stopServer();
            this.server = null;
        }
    }

    @Override
    public void send(YETEvent<?> message) {
        try {
            String s = this.writer.writeMessage(message);
            if (this.server != null) {
                this.server.write(s);
            }
        }
        catch (YETWriterException e) {
            e.printStackTrace();
        }
    }

    public static class QueueWorker
    extends Thread {
        protected AtomicBoolean running = new AtomicBoolean();

        @Override
        public void run() {
            this.running.set(true);
        }
    }

    public static class TCPServer
    extends QueueWorker {
        protected final int port;
        protected Set<YETTCPSocket> sockets;
        protected Consumer<String> readConsumer;

        public TCPServer(int port, Consumer<String> readConsumer) throws IOException {
            this.readConsumer = readConsumer;
            this.port = port;
            this.sockets = new HashSet<YETTCPSocket>();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            super.run();
            System.out.println("Starting new TCP Server on port " + this.port);
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (ServerSocket server = new ServerSocket(this.port);){
                    while (true) {
                        if (!this.running.get()) {
                            System.out.println("Stopping TCP Server on port " + this.port);
                            this.sockets.forEach(it -> it.running.set(false));
                            return;
                        }
                        server.setSoTimeout(1000);
                        try {
                            YETTCPSocket socket = new YETTCPSocket(server.accept(), this.readConsumer);
                            this.sockets.removeIf(it -> !it.running.get());
                            socket.start();
                            this.sockets.add(socket);
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void stopServer() {
            this.running.set(false);
        }

        public void write(String s) {
            this.sockets.forEach(socket -> socket.write(s));
        }
    }

    public static class YETTCPSocket
    extends QueueWorker {
        protected Socket socket;
        protected Queue<String> out;
        protected Consumer<String> readConsumer;

        public YETTCPSocket(Socket socket, Consumer<String> readConsumer) {
            this.readConsumer = readConsumer;
            this.out = new LinkedBlockingQueue<String>();
            this.socket = socket;
        }

        public void write(String s) {
            this.out.add(s);
        }

        @Override
        public void run() {
            super.run();
            BufferedReader reader = null;
            PrintWriter writer = null;
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                    writer = new PrintWriter(this.socket.getOutputStream(), true);
                    while (this.running.get()) {
                        block16: {
                            this.socket.setSoTimeout(1);
                            try {
                                String nextLine = reader.readLine();
                                if (nextLine == null) {
                                    this.running.set(false);
                                    break block16;
                                }
                                this.readConsumer.accept(nextLine);
                            }
                            catch (SocketTimeoutException nextLine) {}
                        }
                        while (!this.out.isEmpty()) {
                            String s = this.out.remove();
                            this.socket.getOutputStream().write(s.getBytes());
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        reader.close();
                        writer.close();
                        this.socket.close();
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                    this.socket.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

