/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.yet.core.protocol;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.yakindu.yet.core.YETEvent;
import com.yakindu.yet.core.config.IYETConfigParameters;
import com.yakindu.yet.core.format.YETParserException;
import com.yakindu.yet.core.format.YETWriter;
import com.yakindu.yet.core.format.YETWriterException;
import com.yakindu.yet.core.logging.IConsoleLogger;
import com.yakindu.yet.core.protocol.IYETMessageSender;
import com.yakindu.yet.core.protocol.YETAbstractMessagePort;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class YETUDPPort
extends YETAbstractMessagePort
implements IYETConfigParameters,
IYETMessageSender {
    private UDPEndpoint server;
    private Thread thread;
    @Inject
    @Named(value="YET_PROVIDER_UDP_PORT")
    protected Integer udpPort;
    @Inject
    @Named(value="YET_PROVIDER_UDP_ADDRESS")
    protected String udpAddress;
    @Inject
    public IConsoleLogger logger;
    @Inject
    protected YETWriter writer;

    @Override
    public void start() throws Exception {
        super.start();
        System.setProperty("java.net.preferIPv4Stack", "true");
        if (this.server == null && this.thread == null) {
            InetAddress address = null;
            try {
                address = InetAddress.getByName(this.udpAddress);
            }
            catch (Exception e) {
                this.logger.logError(e);
            }
            this.server = new UDPEndpoint(this, address, this.udpPort, this.logger);
            this.thread = new Thread((Runnable)this.server, "YET.UDPEndpoint." + String.valueOf(this.udpPort));
            this.thread.start();
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (!this.isRunning() && this.server != null) {
            this.server.running = false;
            this.thread.interrupt();
            this.thread = null;
            this.server = null;
        }
    }

    @Override
    public void send(YETEvent<?> message) {
        try {
            String string = this.writer.writeMessage(message);
            this.server.send(string);
        }
        catch (YETWriterException e) {
            e.printStackTrace();
        }
    }

    public static class UDPEndpoint
    implements Runnable {
        protected IConsoleLogger logger;
        protected byte[] buffer = new byte[512];
        protected YETUDPPort parent;
        protected DatagramSocket socket;
        protected MulticastSocket multicastSocket;
        protected InetAddress udpMulticastAddress;
        protected int udpPort;
        protected SocketAddress client;
        protected Queue<Runnable> tasks;
        public volatile boolean running;

        public UDPEndpoint(YETUDPPort parent, InetAddress address, int port, IConsoleLogger logger) throws IOException {
            this.udpMulticastAddress = address;
            this.udpPort = port;
            if (this.udpMulticastAddress.isMulticastAddress()) {
                logger.log("configure UDP receiver for multicast");
                this.multicastSocket = new MulticastSocket(this.udpPort);
                this.multicastSocket.joinGroup(this.udpMulticastAddress);
                this.socket = this.multicastSocket;
            } else {
                this.socket = new DatagramSocket(this.udpPort);
            }
            this.parent = parent;
            this.logger = logger;
            this.tasks = new LinkedBlockingQueue<Runnable>();
        }

        public void send(String s) {
            this.tasks.add(() -> {
                if (this.client == null) {
                    this.logger.log("send: " + s + " FAILED - no unicast receiver available.");
                    return;
                }
                this.logger.log("send: " + s);
                byte[] buffer = s.getBytes();
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length, this.client);
                try {
                    this.socket.send(packet);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }

        protected void updateClient(SocketAddress sockAddress) {
            if (this.client != null && !this.client.equals(sockAddress) || sockAddress != null && !sockAddress.equals(this.client)) {
                this.logger.log("Switch destination from " + String.valueOf(this.client) + " to " + String.valueOf(sockAddress));
                this.client = sockAddress;
            }
        }

        private Runnable getDefaultTask() {
            return () -> {
                DatagramPacket packet = new DatagramPacket(this.buffer, this.buffer.length);
                try {
                    this.socket.setSoTimeout(1);
                    this.socket.receive(packet);
                    this.updateClient(packet.getSocketAddress());
                    String message = new String(packet.getData(), 0, packet.getLength());
                    try {
                        YETEvent<?> yetMessage = this.parent.parse(message);
                        this.logger.log("receive: " + message);
                        this.parent.provide(yetMessage);
                    }
                    catch (YETParserException e) {
                        this.logger.log("ignore invalid: " + message);
                    }
                }
                catch (SocketTimeoutException message) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
        }

        private Runnable getNextTask() {
            if (!this.tasks.isEmpty()) {
                return this.tasks.poll();
            }
            return this.getDefaultTask();
        }

        @Override
        public void run() {
            this.running = true;
            this.logger.log("Start listening for UDP messages...");
            try {
                while (this.running) {
                    this.getNextTask().run();
                }
            }
            finally {
                this.logger.log("Closing socket.");
                this.socket.close();
            }
        }
    }
}

