/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.yet.sct.debugger.ui;

import com.yakindu.yet.core.config.IYETConfigParameters;
import com.yakindu.yet.sct.debugger.util.StatechartNameParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class YETLaunchConfigurationTab
extends AbstractLaunchConfigurationTab
implements IYETConfigParameters {
    private static final String SCT_EXTENSION = "sct";
    private static final String TRACING_EXTENSION = "yet";
    private String traceProvider;
    private Composite rootComposite;
    private Text instanceName;
    private Button yetFileButton;
    private Button yetUDPButton;
    private Button yetTCPButton;
    private Composite fileSection;
    private Text filePath;
    private Composite udpSection;
    private Text udpAddress;
    private Text udpPort;
    private Composite tcpSection;
    private Text tcpPort;
    private Button consoleLogButton;

    public void createControl(Composite parent) {
        this.rootComposite = new Composite(parent, 0);
        this.singleColumn(this.gridLayout(this.rootComposite));
        this.setControl((Control)this.rootComposite);
        this.createMainSection(this.rootComposite);
        this.createFileSection(this.rootComposite);
        this.createUDPSection(this.rootComposite);
        this.createTCPSection(this.rootComposite);
        this.createLoggingSection(this.rootComposite);
    }

    protected void createMainSection(Composite parent) {
        Group mainGroup = new Group(this.rootComposite, 0);
        mainGroup.setText("Statechart Remote Tracing options");
        this.fillGridHorizontal(mainGroup);
        this.singleColumn(this.gridLayout((Composite)mainGroup));
        Group instanceGroup = this.createStandardGroup((Composite)mainGroup, "Instance name");
        this.instanceName = this.createText((Composite)instanceGroup);
        Group optionsGroup = this.createStandardGroup((Composite)mainGroup, "Trace provider");
        this.createMainOptions((Composite)optionsGroup);
    }

    protected void createMainOptions(Composite parent) {
        this.yetFileButton = new Button(parent, 16);
        this.yetUDPButton = new Button(parent, 16);
        this.yetTCPButton = new Button(parent, 16);
        this.yetFileButton.setText("Read trace from file");
        this.yetUDPButton.setText("Read trace from UDP socket");
        this.yetTCPButton.setText("Read trace from TCP socket");
        this.yetFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == YETLaunchConfigurationTab.this.yetFileButton) {
                    YETLaunchConfigurationTab.this.traceProvider = "YET_PROVIDER_FILE";
                    YETLaunchConfigurationTab.this.updateSectionVisibility();
                    YETLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.yetUDPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == YETLaunchConfigurationTab.this.yetUDPButton) {
                    YETLaunchConfigurationTab.this.traceProvider = "YET_PROVIDER_UDP";
                    YETLaunchConfigurationTab.this.updateSectionVisibility();
                    YETLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.yetTCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == YETLaunchConfigurationTab.this.yetTCPButton) {
                    YETLaunchConfigurationTab.this.traceProvider = "YET_PROVIDER_TCP";
                    YETLaunchConfigurationTab.this.updateSectionVisibility();
                    YETLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    protected void createFileSection(Composite parent) {
        this.fileSection = this.createGroup(parent, "File");
        this.fillGridHorizontal(this.fileSection);
        this.singleColumn(this.gridLayout(this.fileSection));
        Group pathGroup = this.createStandardGroup(this.fileSection, "Path");
        pathGroup.setLayout((Layout)new GridLayout(2, false));
        this.filePath = this.createText((Composite)pathGroup);
        Button btnBrowseTracingFile = new Button((Composite)pathGroup, 0x800000);
        btnBrowseTracingFile.setText("Search");
        btnBrowseTracingFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(YETLaunchConfigurationTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                dialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof IFile) {
                            return ((IFile)element).getName().toLowerCase().endsWith(".yet");
                        }
                        return true;
                    }
                });
                dialog.setTitle("Select trace file");
                dialog.setMessage("Please select the trace (.yet) file you want to execute.");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                if (dialog.open() == 0) {
                    Object[] files = dialog.getResult();
                    IFile file = (IFile)files[0];
                    YETLaunchConfigurationTab.this.filePath.setText(file.getFullPath().toString());
                }
            }
        });
    }

    protected void createUDPSection(Composite parent) {
        this.udpSection = this.createGroup(parent, "UDP");
        this.fillGridHorizontal(this.udpSection);
        this.singleColumn(this.gridLayout(this.udpSection));
        Group udpAddressGroup = this.createStandardGroup(this.udpSection, "Multicast address (optional)");
        this.udpAddress = this.createText((Composite)udpAddressGroup);
        Group udpPortGroup = this.createStandardGroup(this.udpSection, "Port");
        this.udpPort = this.createText((Composite)udpPortGroup);
    }

    protected void createTCPSection(Composite parent) {
        this.tcpSection = this.createGroup(parent, "TCP");
        this.fillGridHorizontal(this.tcpSection);
        this.singleColumn(this.gridLayout(this.tcpSection));
        Group tcpGroup = this.createStandardGroup(this.tcpSection, "Port");
        this.tcpPort = this.createText((Composite)tcpGroup);
    }

    protected void createLoggingSection(Composite parent) {
        this.consoleLogButton = new Button(parent, 32);
        this.consoleLogButton.setText("Log to console");
        this.consoleLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                YETLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void setTraceProviderSelection() {
        if ("YET_PROVIDER_FILE".equals(this.traceProvider)) {
            this.yetFileButton.setSelection(true);
            this.yetUDPButton.setSelection(false);
            this.yetTCPButton.setSelection(false);
        } else if ("YET_PROVIDER_UDP".equals(this.traceProvider)) {
            this.yetFileButton.setSelection(false);
            this.yetUDPButton.setSelection(true);
            this.yetTCPButton.setSelection(false);
        } else if ("YET_PROVIDER_TCP".equals(this.traceProvider)) {
            this.yetFileButton.setSelection(false);
            this.yetUDPButton.setSelection(false);
            this.yetTCPButton.setSelection(true);
        } else {
            this.traceProvider = "YET_PROVIDER_UDP";
            this.setTraceProviderSelection();
        }
    }

    protected void updateSectionVisibility() {
        if (this.yetFileButton.getSelection()) {
            this.setVisible(this.fileSection, true);
            this.setVisible(this.udpSection, false);
            this.setVisible(this.tcpSection, false);
        }
        if (this.yetUDPButton.getSelection()) {
            this.setVisible(this.fileSection, false);
            this.setVisible(this.udpSection, true);
            this.setVisible(this.tcpSection, false);
        }
        if (this.yetTCPButton.getSelection()) {
            this.setVisible(this.fileSection, false);
            this.setVisible(this.udpSection, false);
            this.setVisible(this.tcpSection, true);
        }
        this.rootComposite.pack();
    }

    protected void setVisible(Composite composite, boolean visible) {
        composite.setVisible(visible);
        Object layoutData = composite.getLayoutData();
        if (layoutData instanceof GridData) {
            GridData gridData = (GridData)layoutData;
            gridData.exclude = !visible;
        }
    }

    public String getName() {
        return "Statechart Trace";
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String fileName = configuration.getAttribute("filename", "");
            String projectName = "";
            String statechartName = "";
            if (fileName != "") {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName));
                if (SCT_EXTENSION.equals(file.getFileExtension())) {
                    statechartName = StatechartNameParser.parse((IFile)file);
                }
                projectName = file.getProject().getName();
            }
            this.instanceName.setText(configuration.getAttribute("LaunchInstance", statechartName));
            this.traceProvider = configuration.getAttribute("YET_PROVIDER", "YET_PROVIDER_UDP");
            this.setTraceProviderSelection();
            this.filePath.setText(configuration.getAttribute("YET_PROVIDER_FILE_PATH", projectName + "/trace.yet"));
            this.udpAddress.setText(configuration.getAttribute("YET_PROVIDER_UDP_ADDRESS", ""));
            this.udpPort.setText(configuration.getAttribute("YET_PROVIDER_UDP_PORT", "4444"));
            this.tcpPort.setText(configuration.getAttribute("YET_PROVIDER_TCP_PORT", "8444"));
            this.consoleLogButton.setSelection(new Boolean(configuration.getAttribute("YET_CONSOLE_LOG", "true")).booleanValue());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.updateSectionVisibility();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return super.isValid(launchConfig);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("LaunchInstance", this.instanceName.getText());
        configuration.setAttribute("YET_PROVIDER", this.traceProvider);
        configuration.setAttribute("YET_PROVIDER_FILE_PATH", this.filePath.getText());
        configuration.setAttribute("YET_PROVIDER_UDP_ADDRESS", this.udpAddress.getText());
        configuration.setAttribute("YET_PROVIDER_UDP_PORT", this.udpPort.getText());
        configuration.setAttribute("YET_PROVIDER_TCP_PORT", this.tcpPort.getText());
        configuration.setAttribute("YET_CONSOLE_LOG", "" + this.consoleLogButton.getSelection());
    }

    protected Group createStandardGroup(Composite parent, String label) {
        Group group = this.createGroup(parent, label);
        this.horizontal(this.fillLayout((Composite)this.fillGridHorizontal(group)));
        return group;
    }

    protected Group createGroup(Composite parent, String label) {
        Group group = new Group(parent, 0);
        group.setText(label);
        return group;
    }

    protected Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        this.updateLaunchConfigurationOnChange(text);
        return text;
    }

    protected <T extends Widget> T updateLaunchConfigurationOnChange(T widget) {
        widget.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                YETLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        return widget;
    }

    protected GridLayout gridLayout(Composite comp) {
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        return layout;
    }

    protected GridLayout singleColumn(GridLayout layout) {
        layout.numColumns = 1;
        return layout;
    }

    protected FillLayout fillLayout(Composite comp) {
        FillLayout layout = new FillLayout();
        comp.setLayout((Layout)layout);
        return layout;
    }

    protected FillLayout horizontal(FillLayout layout) {
        layout.type = 256;
        return layout;
    }

    protected <T extends Control> T fillGridHorizontal(T control) {
        control.setLayoutData((Object)new GridData(768));
        return control;
    }
}

