/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.ui

import org.eclipse.ui.plugin.AbstractUIPlugin
import org.eclipse.xtext.ui.editor.model.JavaClassPathResourceForIEditorInputFactory
import org.eclipse.xtext.ui.editor.model.ResourceForIEditorInputFactory
import org.eclipse.xtext.ui.resource.SimpleResourceSetProvider
import org.eclipse.xtext.ui.resource.XtextResourceSetProvider
import org.eclipse.xtext.ui.shared.Access

/** 
 * Use this class to register components to be used within the IDE.
 */
class ExpressionsUiModule extends AbstractExpressionsUiModule {

	new(AbstractUIPlugin plugin) {
		super(plugin)
	}

	override provideIAllContainersState() {
		return if (Access.getJdtHelper().get().isJavaCoreAvailable()) {
			Access.getJavaProjectsState()
		} else {
			Access.getWorkspaceProjectsState()
		}
	}

	override bindIResourceSetProvider() {
		return if (Access.getJdtHelper().get().isJavaCoreAvailable()) {
			XtextResourceSetProvider
		} else {
			SimpleResourceSetProvider
		}
	}

	override bindIResourceForEditorInputFactory() {
		return if (Access.getJdtHelper().get().isJavaCoreAvailable()) {
			JavaClassPathResourceForIEditorInputFactory
		} else {
			ResourceForIEditorInputFactory
		}
	}
}
