/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	andreas muelder - itemis AG
 * 
 */
package com.yakindu.sct.domain.java.validation

import com.google.inject.Inject
import org.eclipse.xtext.validation.Check
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Expression
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sct.model.stext.validation.STextValidator

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class JavaDomainValidator extends STextValidator {

	@Inject extension ExpressionExtensions

	public static val TYPE_ASSIGNMENT = "Cannot assign a type."

	@Check
	def checkTypeAssignment(AssignmentExpression assignment) {
		if (assignment.expression.isComplexType) {
			error(JavaDomainValidator.TYPE_ASSIGNMENT, null)
		}
	}

	@Check
	def checkTypeAssignment(VariableDefinition varDef) {
		if (varDef.initialValue !== null && varDef.initialValue.isComplexType) {
			error(JavaDomainValidator.TYPE_ASSIGNMENT, null)
		}
	}
	
	def dispatch isComplexType(Void exp) {
		false
	}

	def dispatch isComplexType(Expression exp) {
		false
	}

	def dispatch isComplexType(ArgumentExpression exp) {
		return exp.featureOrReference instanceof ComplexType
	}

}
