/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.TypedRxCExtensions
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import java.util.List
import com.itemis.create.base.model.bindings.ReactiveModel

class ScTypesIncludeProvider implements IncludeProvider {
	
	@Inject protected extension FileNaming 
	@Inject protected extension GeneratorPredicate
	@Inject protected extension SExecExtensions
	@Inject protected extension TypedRxCExtensions
	@Inject protected extension ReactiveModel
	
	override getIncludes(ExecutionFlow it, extension IGenArtifactConfigurations artifactConfigs) {
		val List<CharSequence> scIncludes = newArrayList('''#include "«(typesModule.h).relativeTo(module.h)»"''')
		if((useOutEventObservables && hasOutgoingEvents) || referencesReactiveTypes) {
			scIncludes.add('''#include "«(rxcModule.h).relativeTo(module.h)»"''')
			addCustomPayloadTypeIncludes(scIncludes, artifactConfigs)
		}
		return scIncludes
	}
	
	def protected addCustomPayloadTypeIncludes(ExecutionFlow it, List<CharSequence> scIncludes, extension IGenArtifactConfigurations artifactConfigs) {
		for(payloadType : payloadTypes) {
			scIncludes.add('''#include "«payloadType.typedRxcModule.h.relativeTo(module.h)»"''')
		}		
	}
	
}