/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.extensions

import com.google.inject.Inject
import com.google.inject.name.Named
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Event
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.concepts.EventBuffer
import com.yakindu.sct.model.sexec.concepts.RunCycleMethod
import com.yakindu.sct.model.sexec.concepts.ShadowMemberScope
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.sgraph.State
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.naming.StextNameProvider
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.OperationDefinition
import com.yakindu.sct.model.stext.stext.VariableDefinition
import org.eclipse.emf.ecore.EObject

import static com.yakindu.sct.generator.c.CGeneratorConstants.*

class Naming {
	@Inject @Named("Separator") protected String sep;

	@Inject protected extension SExecExtensions
	
	@Inject protected extension CTypes
	@Inject protected extension FileNaming
		
	@Inject protected extension ICodegenTypeSystemAccess

	@Inject protected StextNameProvider provider
	
	@Inject protected extension GeneratorEntryProvider

	@Inject protected extension INamingService
	
	@Inject extension GenmodelEntries
	
	@Inject extension StatechartUtil
	@Inject extension OriginTracing
	@Inject extension EventBuffer
	@Inject protected extension ShadowMemberScope
	@Inject protected extension EventNaming
	@Inject protected extension RunCycleMethod
	
	def getFullyQualifiedName(State state) {
		provider.getFullyQualifiedName(state).toString.asEscapedIdentifier
	}

	def timerType(ExecutionFlow it) {
		'SCTimer'
	}
	
	def statesEnumType(ExecutionFlow it) {
		containerType + 'States'
	}
	
	def featuresEnumType(ExecutionFlow it) {
		containerType + 'Feature'
	}
	
	def protected String entryStatemachinePrefix(Statechart it) {
		getEntry.statemachinePrefix
	}
	
	def protected String entryStatemachinePrefix(ExecutionFlow it) {
		getEntry.statemachinePrefix
	}

	def dispatch String type(InterfaceScope it) {
		containerType + 'Iface' + (if(name.nullOrEmpty) '' else name).asIdentifier.toFirstUpper
	}

	def dispatch String type(InternalScope it) {
		if ( it.isShadowMemberScope ) containerType + 'Shadow'
		else containerType + 'Internal'
	}

	def dispatch String type(Scope it) {
		containerType + 'TimeEvents'
	}

	def dispatch String type(Property it) {
		containerType + it.type.name
	}

	def dispatch String type(ExecutionFlow it) {
		if (entryStatemachinePrefix.nullOrEmpty) {
			return name.asIdentifier.toFirstUpper
		}
		return entryStatemachinePrefix.toFirstUpper
	}
	
	def dispatch String type(Statechart it) {
		if(entryStatemachinePrefix.nullOrEmpty) {
			return name.asIdentifier.toFirstUpper
		}
		return entryStatemachinePrefix.toFirstUpper
	}
	
	
	def dispatch String cType(EObject it) {
		type
	}
	
	def dispatch String cType(ExecutionFlow it) {
		type
	}
	
	def dispatch String cType(Type it) {
		if (! it.targetLanguageName.isNullOrEmpty) return targetLanguageName
		if (! it.name.isNullOrEmpty) return it.name
		
		val typeSuffix = if (it.isEventBuffer) "EvBuf" else ""
		val typeOrigin = it.originTraces.filter(EObject).head
		
		if (typeOrigin !== null) typeOrigin.cType + typeSuffix 
		else typeSuffix
	}
	
	
	def String getContainerType(EObject it) {
		if (flow !== null) {
			return flow.type
		}
		return statechart.type
	}

	def dispatch instance(InterfaceScope it) {
		'iface' + (if(name.nullOrEmpty) '' else name).asIdentifier.toFirstUpper
	}
	
	def dispatch instance(Void it) {
		"no scope!"
	}

	def dispatch instance(Scope it) {
		'timeEvents'
	}

	def dispatch instance(InternalScope it) {
		if ( it.isShadowMemberScope ) 'shadow'
		else 'internal'
	}

	def functionPrefix(Scope it) {
		val prefix = (statechart?.entryStatemachinePrefix ?: flow?.entryStatemachinePrefix)
		if (!prefix.nullOrEmpty) {
			prefix + instance.toFirstUpper
		} else {
			(switch(it) {
				InterfaceScope case name.nullOrEmpty : containerType
				InterfaceScope case !name.nullOrEmpty: containerType + separator + name
				InternalScope: containerType + separator + "internal"
			}).toFirstLower
		}
	}

	def functionPrefix(ExecutionFlow it) {
		if (!entryStatemachinePrefix.nullOrEmpty) {
			return entryStatemachinePrefix + separator
		}
		containerType.asIdentifier.toFirstLower + separator
	}
	
	def functionPrefix(Statechart it) {
		if(it !== null){
			if (!entryStatemachinePrefix.nullOrEmpty) {
				return entryStatemachinePrefix + separator
			}
			containerType.asIdentifier.toFirstLower + separator
		}
	}
	
	def structName(Type it){
		'''sc_«name.split("(?=[A-Z])").join("_").toLowerCase»'''
	}

	def separator() {
		var sep = this.sep
		if (sep.nullOrEmpty) {
			sep = "_"
		}
		return sep
	}

	def dispatch String null_state(ExecutionFlow it) {
		type + lastStateID
	}
	
	def dispatch String null_state(Statechart it) {
		type + lastStateID
	}

	def dispatch String null_state(Step it) {
		execution_flow.null_state
	}

	def lastStateID() {
		separator + "last" + separator + "state"
	}

	def stateVectorDefine(ExecutionState it) {
		'''SCVI_«shortName»'''.toString.toUpperCase
	}

	def ExecutionFlow execution_flow(EObject element) {
		var ret = element;

		while (ret !== null) {
			if (ret instanceof ExecutionFlow) {
				return ret
			} else {
				ret = ret.eContainer;
			}
		}
		return null;
	}
	
	/**
	 * TODO: move method it is for declaration not naming
	 */
	def scopeShadowEventMember(Event it) {
		'''
		«sc_single_subscription_observer.name»«eventType» «eventName»;
		'''
	}

	def constantName(VariableDefinition it) {
		(containerType + separator + scope.type + separator + name.asEscapedIdentifier).toUpperCase
	}

	def raiseTimeEventFctID(ExecutionFlow it) {
		functionPrefix + RAISE_TIME_EVENT
	}
	
	def raiseTimeEventFctID(Statechart it) {
		functionPrefix + RAISE_TIME_EVENT
	}

	def isStateActiveFctID(ExecutionFlow it) {
		functionPrefix + IS_STATE_ACTIVE
	}
	
	def isStateActiveFctID(Statechart it) {
		functionPrefix + IS_STATE_ACTIVE
	}

	def isActiveFctID(ExecutionFlow it) {
		functionPrefix + IS_ACTIVE
	}
	
	def isActiveFctID(Statechart it) {
		functionPrefix + IS_ACTIVE
	}

	def isFinalFctID(ExecutionFlow it) {
		functionPrefix + IS_FINAL
	}
	
	def isFinalFctID(Statechart it) {
		functionPrefix + IS_FINAL
	}
	
	def initFctID(ExecutionFlow it) {
		functionPrefix + INIT
	}
	
	def initFctID(Statechart it) {
		functionPrefix + INIT
	}
	
	def enterFctID(ExecutionFlow it) {
		functionPrefix + ENTER
	}
	
	def enterFctID(Statechart it) {
		functionPrefix + ENTER
	}

	def exitFctID(ExecutionFlow it) {
		functionPrefix + EXIT
	}
	
	def exitFctID(Statechart it) {
		functionPrefix + EXIT
	}
	
	def triggerWithoutEventFctID(ExecutionFlow it) {
		functionPrefix + TRIGGER_WITHOUT_EVENT
	}
	
	def runSubmachineCycleID(ExecutionFlow it) {
		functionPrefix + RUN_SUBMACHINE_CYCLE
	}
	
	def enableNextEventID(ExecutionFlow it) {
		functionPrefix + ENABLE_NEXT_EVENT
	}
	
	def setSubmachineContextID(ExecutionFlow it) {
		functionPrefix + SET_SUBMACHINE_CONTEXT
	}
	
	def eventRaisedID(ExecutionFlow it) {
		functionPrefix + EVENT_RAISED
	}
	
	def triggerWithoutEventFctID(Statechart it) {
		functionPrefix + TRIGGER_WITHOUT_EVENT
	}
	
	
	def runCycleFctID(ExecutionFlow it) {
		if(hasRunCycleFunctionAsAPI) {
			return functionPrefix + RUN_CYCLE
		}
		RUN_CYCLE
	}
	
	def runCycleFctID(Statechart it) {
		if(hasRunCycleFunctionAsAPI) {
			return functionPrefix + RUN_CYCLE
		}
		RUN_CYCLE
	}
	
	def eventValueVariable(Event it) {
		name.asIdentifier.value
	}
	
	def eventName(Event it) {
		name.asIdentifier
	}
	
	def timeEventRaisedFlag(TimeEvent it) {
		shortName.raised
	}
	
	def eventRaisedFlag(Event it) {
		 name.asIdentifier.raised
	}
	
	def setTimerFctID(ExecutionFlow it) {
		functionPrefix + SET_TIMER
	}
	
	def unsetTimerFctID(ExecutionFlow it) {
		functionPrefix + UNSET_TIMER
	}
	
	def enterStateTracingFctID(ExecutionFlow it) {
		functionPrefix + STATE_ENTERED
	}
	
	def exitStateTracingFctID(ExecutionFlow it) {
		functionPrefix + STATE_EXITED
	}
 
	def asRaiser(Event it) {
		accessFunction("raise")
	}

	def asRaised(Event it) {
		accessFunction("is_raised")
	}
	
	def asObservableGetter(Event it) {
		accessFunction("get")
	}

	def dispatch asGetter(EventDefinition it) {
		accessFunction("get").value
	}

	def dispatch asGetter(VariableDefinition it) {
		accessFunction("get")
	}
	
	def dispatch asGetter(EObject it) '''Cannot find getter for «it»'''
	
	def dispatch assign(Declaration it) {
		accessFunction("assign")
	}
	
	def dispatch assign(EObject it) '''Cannot find assignment method for'''

	def dispatch String asSetter(Declaration it) {
		accessFunction("set")
	}
	
	def dispatch String asSetter(EObject it) '''Cannot find setter for «it»'''
	
	def dispatch String asSetter(String it) '''Cannot find setter for «it»'''
	
	def asFunction(Operation it) {
		scope.functionPrefix + separator + name.asIdentifier.toFirstLower
	}
	
	def accessFunction(Declaration it, String funcName) {
		scope.functionPrefix + separator + funcName + separator + name.asIdentifier.toFirstLower
	}
	
	def dispatch variable(Property it) {
		name.asIdentifier
	}
	
	def dispatch variable(VariableDefinition it) {
		name.asEscapedIdentifier
	}
	
	def stateName(ExecutionState it) {
		shortName
	}
	
	def stateName(RegularState it) {
		shortName
	}
	
	def raised(CharSequence it) { it + separator + 'raised' }

	def value(CharSequence it) { it + separator + 'value' }

	def scHandleDecl(EObject it) { containerType + '* ' + scHandle }

	def scHandle() { HANDLE }

	def valueParams(EventDefinition it) {
		if(hasValue) ', ' + typeSpecifier.targetLanguageName + ' value' else ''
	}

	def dispatch access(VariableDefinition it) {
		if (isConst) '''«it.constantName»''' else '''«IF needsHandle»«scHandle»«ENDIF»->«IF scope !== null»«scope.instance»«ENDIF».«name.asEscapedIdentifier»'''
	}
	
	def needsHandle(EObject it) {
		!(eContainer instanceof ComplexType)
	}
	
	def dispatch access(Property it) {
		'''«name.asIdentifier»'''
	}

	def dispatch access(Operation it) {
		'''«name.asEscapedIdentifier»'''
	}

	def dispatch access(Method it) {
		if ( it === flow.runCycle) {
			flow.runCycleFctID
		}
		else 
			'''«shortName»'''
		
	}
	
	def dispatch access(Enumerator it) {
		'''«name.asEscapedIdentifier»'''
	}

	def dispatch access(OperationDefinition it) '''«asFunction»'''

	def dispatch access(EventDefinition it) '''«IF needsHandle»«scHandle»«ENDIF»->«scope.instance».«name.asIdentifier.raised»'''

	def dispatch access(Event it) '''«name.asIdentifier.raised»'''
	
	def dispatch accessObservable(Event it) '''«IF needsHandle»«scHandle»«ENDIF»->«scope.instance».«name.asIdentifier»'''
	
	def dispatch accessObservable(EObject it) ''''''
	
	def dispatch accessObserver(Event it) '''«IF needsHandle»«scHandle»«ENDIF»->«scope.instance».«name.asIdentifier»'''
	
	def dispatch accessObserver(EObject it) ''''''
	
	def dispatch observerCallbackFctID(Event it) '''on_«name.asIdentifier»'''
	
	def dispatch observerCallbackFctID(EObject it) ''''''

	def dispatch access(TimeEvent it) '''«scHandle»->«scope.instance».«shortName.raised»'''

	def dispatch access(EObject it) '''#error cannot access elements of type «getClass.name»'''

	def dispatch valueAccess(Declaration it)'''«IF needsHandle»«scHandle»->«ENDIF»«scope.instance».«name.asIdentifier.value»'''
	
	def dispatch valueAccess(EObject it) '''#error cannot value access elements of type «getClass.name»'''

	def dispatch valueDeclaration(TypedDeclaration it) '''«typeSpecifier.targetLanguageName» «valueName»'''
	
	def dispatch valueDeclaration(EObject it) ''''''
	
	def dispatch valueName(TypedDeclaration it) '''«scope.instance»_«name.asIdentifier.value»'''
	
	def dispatch valueName(EObject it) ''''''
	
	def maxOrthogonalStates(ExecutionFlow it) '''«type.toUpperCase»_MAX_ORTHOGONAL_STATES'''

	def maxHistoryStates(ExecutionFlow it) '''«type.toUpperCase»_MAX_HISTORY_STATES'''

	def maxParallelTimeEvents(ExecutionFlow it) '''«type.toUpperCase»_MAX_PARALLEL_TIME_EVENTS'''
	
	def numStates(ExecutionFlow it) '''«type.toUpperCase»_STATE_COUNT'''
	
	def stateEnumAccess(Enumerator it) {
		val statechart = eContainer.getOriginStatechart()
		val state = originState		
		return '''«IF state !== null»«state.stateName.asEscapedIdentifier»«ELSE»«statechart.null_state»«ENDIF»'''
	}
		
	def dispatch getHandle(Expression it) {
		'''/*Cannot find handle for Expression: '«it»' */'''
	}
	
	def dispatch CharSequence getHandle(FeatureCall it) {
		if(feature instanceof VariableDefinition) {
			val owner = owner
			if(owner instanceof FeatureCall) {
				val ownerOfOwner = owner.owner
				// named interface
				if(ownerOfOwner instanceof FeatureCall) {
					return '''«feature.asGetter»(«ownerOfOwner.getHandle»)'''	
				}
				// unnamed interface
				return '''«feature.asGetter»(«owner.getHandle»)'''
			}
			// statechart internal
			return '''«owner.getHandle»«feature.access»'''
			}
		return '''«owner.getHandle»'''
	}
	
	def dispatch getHandle(ElementReferenceExpression it) {
		val reference = reference
		if(reference instanceof VariableDefinition) {
			'''«scHandle»->«reference.scope.instance».«reference.name»'''
		}
	}
	
	def featureEnumMemberName(NamedElement it) {
		#[enumMemberNamePrefix, name.asIdentifier, "feature"].filter[!nullOrEmpty].join("_")
	}
	
	def metaName(Declaration it) {
		provider.qualifiedName(it)
	}
	
	def enumMemberNamePrefix(EObject it) {
		#[containerType, scope.interfaceName].filter[!nullOrEmpty].join("_")
	}
	
	def dispatch interfaceName(Void it) { "" }
	def dispatch interfaceName(Scope it) { "" }
	def dispatch interfaceName(InternalScope it) { "internal" }
	def dispatch interfaceName(InterfaceScope it) { name ?: "" }
	
	def scTracingHandleDecl(EObject it) { TRACE_HANDLER_TYPE + '* ' + TRACE_HANDLER }//sc_trace_handler* trace_handler
	
	def initTracingFctID(ExecutionFlow it) {
		functionPrefix + INIT_TRACING
	}
	
	def setTraceHandlerFctID(ExecutionFlow it) {
		functionPrefix + SET_TRACING
	}
	
	def String getTypeName(TypeSpecifier it) {
		if(type.name == "pointer")
			return typeArguments.head.getTypeName + "_" + type.name
		return type.name
	}
	
	def String getPointerType(TypeSpecifier it) {
		if(type.name == "pointer")
			return typeArguments.head.pointerType + "*"
		return type.name
	}
	
	def metaPrefix(ExecutionFlow it) {
		META_MODULE + separator
	}
	
	def metaSuffix(ExecutionFlow it) {
		separator + META_MODULE
	}
	
	def metaFeaturesProperty(ExecutionFlow it) {
		'''«metaModule»_feature_names'''
	}
	
	def metaStatesProperty(ExecutionFlow it) {
		'''«metaModule»_state_names'''
	}
	
	def tracingPrefix(ExecutionFlow it){
		TRACE_CALL + separator
	}
	
	def traceFctID(ExecutionFlow it) {
		TRACE_CALL
	}
	
}
