/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.extensions

import com.google.inject.Inject
import com.yakindu.base.types.Event
import com.yakindu.base.types.typesystem.GenericTypeSystem
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions

/**
 * @author Robin Herrmann
 */
class TypedRxCExtensions {
	@Inject extension GenericTypeSystem
	@Inject extension SExecExtensions

	/**
	 * Returns all payload types, except defaults (integer, boolean, etc.), 
	 * which are already defined & declared in the rcx module.
	 */
	def getPayloadTypes(ExecutionFlow it) {
		return eAllContents.filter(Event).filter[hasValue].map[typeSpecifier].
			filter[ts|!concreteTypes.map[name].toList.contains(ts.type.name)].toSet
	}
}
