/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * 	Mathias Alexander Schulte- itemis AG
 * 	Axel Terfloth - itemis AG
 */
package com.yakindu.sct.generator.c.files

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sexec.naming.INamingService

class MetaHeader implements IContentTemplate<ExecutionFlow> {
	@Inject extension GenmodelEntries
	@Inject extension Naming
	@Inject extension FileNaming
	@Inject protected extension INamingService
	@Inject extension CTypes
	@Inject extension SExecExtensions
	
	override content(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»

		#ifndef «flow.module.define»_META_H_
		#define «flow.module.define»_META_H_

		#include "«(typesModule.h).relativeTo(flow.metaModule.h)»"

		#ifdef __cplusplus
		extern "C" {
		#endif
		
		#define «flow.metaFeaturesProperty»_size «flow.scopes.map[it | it.eventAndVariableDefinitions].flatten.size + 1»
		extern «sc_string.name» «flow.metaFeaturesProperty»[];
		
		#define «flow.metaStatesProperty»_size «flow.states.size +1»
		extern «sc_string.name» «flow.metaStatesProperty»[];
		
		#ifdef __cplusplus
		}
		#endif

		#endif /* «flow.module.define»_META_H_ */
		'''
	}
	
	def protected removePrefix(String s){
		return s.substring(s.indexOf(".")+1)
	}
}