package com.yakindu.sct.generator.c.files

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Operation
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.StatemachineTypes
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.nodemodel.impl.RootNode

class StatemachineTypeHeader implements IContentTemplate<ExecutionFlow> {

	@Inject protected extension GenmodelEntries
	@Inject protected extension Naming
	@Inject protected extension FileNaming
	@Inject protected extension StatemachineTypes

	override content(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations) {
		val types = flow.declaredInternalStatemachineTypes
		'''
		«entry.licenseText»
		#ifndef «statemachineModule.toUpperCase»_H_
		#define «statemachineModule.toUpperCase»_H_
		
		#ifdef __cplusplus
		extern "C"
		{
		#endif
		
		#include "«(typesModule.h)»"
		«FOR t : types»
			«FOR f : t.getAllFeatures.filter(Operation)»
				«IF f.eContainer == t»
				«f.eAdapters.filter(RootNode).head.completeContent»
				typedef «f.type.cType» (*«t.structName»_«f.name»_fp)(void *handle);
				«ENDIF»
			«ENDFOR»
		«ENDFOR»
		«FOR t : types»
				
		/* struct of a dynamic «t.name» interface. */
		typedef struct {
			«IF t.superTypes.nullOrEmpty»void *machine«ELSE»«t.superTypes.map[type].filter(ComplexType).head.structName»_t statemachine_type«ENDIF»;
			«FOR f : t.getAllFeatures.filter(Operation)»
			«IF f.eContainer == t»
			«t.structName»_«f.name»_fp «f.name»;
			«ENDIF»
			«ENDFOR»
		} «t.structName»_t;
		«ENDFOR»
		
		«FOR t : types»
			«FOR f : t.getAllFeatures.filter(Operation)»
				«IF f.eContainer == t»
				extern «f.type.cType» sc_«f.name»(«t.structName»_t *machine);
				«ENDIF»
			«ENDFOR»
		«ENDFOR»
		#ifdef __cplusplus
		}
		#endif
		#endif /* «statemachineModule.toUpperCase»_H_ */
		'''
	}
}