/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.submodules

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Expression
import com.yakindu.sct.generator.c.CExpressionsGenerator
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.c.extensions.EventNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.core.templates.ExpressionsGenerator
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.base.types.Event

/**
 * @author rbeckmann
 * @author axel terfloth
 *
 */
@Singleton // Guice
class EventCode implements com.yakindu.sct.generator.core.submodules.lifecycle.EventCode {

	@Inject protected extension SExecExtensions
	@Inject protected extension Naming
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension Literals
	@Inject protected extension CTypes
	@Inject protected extension	TraceCode 
	@Inject extension ExpressionExtensions
	@Inject extension GeneratorPredicate
	@Inject extension EventNaming
	
	@Inject protected extension GeneratorEntry entry
	@Inject protected extension GenmodelEntries
	
	@Inject protected extension ExpressionsGenerator
	
	@Inject protected extension EventProcessing
	@Inject protected extension ExpressionBuilder
	@Inject protected extension ShadowEventExtensions
	
	
	def interfaceIncomingEventRaiser(ExecutionFlow it, EventDefinition event) '''
		«eventRaiserSignature(event)»
		{
			«event.traceCode( if (event.hasValue) "&value" else "sc_null" )»
			«interfaceIncomingEventRaiserBody(event)»
		}

	'''	

	def interfaceIncomingEventRaiserBody(ExecutionFlow it, EventDefinition event) '''
		«IF event.hasValue»
		«event.valueAccess» = value;
		«ENDIF»
		«event.access» = «TRUE_LITERAL»;
	'''
	
	def interfaceOutgoingEventGetter(ExecutionFlow it, EventDefinition event) '''
		«eventGetterSignature(event)»
		{
			return «event.access»;
		}
	'''
	
	def interfaceOutgoingEventObservableGetter(ExecutionFlow it, EventDefinition event) '''
		«eventObservableSignature(event)»
		{
			return &«event.accessObservable»;
		}
	'''
	
	def interfaceOutgoingEventValueGetter(ExecutionFlow it, EventDefinition event) '''
		«eventValueGetterSignature(event)»
		{
			return «event.valueAccess»;
		}
	'''
	
	def CharSequence eventRaisingCode(EventRaisingExpression it, ExpressionsGenerator exp) {
		if (event.featureOrReference.eContainer instanceof ComplexType) {
			val fc = event as FeatureCall
			return '''«(fc.feature as EventDefinition).asRaiser»(«fc.owner.getHandle»«IF value !== null», «exp.code(value)»«ENDIF»)'''
		}
		val eventDefintion = event.definition.event
		val code = newArrayList
		if(useOutEventObservables && event.definition.event.direction === Direction.OUT){
			if(value !== null)
				code.add('''
				{
					«event.definition.event.valueDeclaration» = «exp.code(value)»;
					sc_observable«eventDefintion.eventType»_next(&«eventDefintion.accessObservable», «eventDefintion.valueName»);
				}''')
			else
				code.add('''sc_observable_next(&«eventDefintion.accessObservable»)''')		
		}
		
		if((useOutEventGetters && eventDefintion.direction == Direction.OUT) || eventDefintion.direction == Direction.IN || eventDefintion.direction == Direction.LOCAL){
				code.add('''«eventDefintion.eventMarker»''')
				if(eventValue(exp) !== null) code.add('''«eventValue(exp)»''')
				if(eventTrace !== null)code.add('''«eventTrace»''')
		}
					
		if(event.definition.event.direction === Direction.OUT && event.definition.event.getLocalOutEvent() !== null)
				code.add('''«raiseLocalOutEvent(exp)»''')
		
		// joining the code fragments is done in multiple steps to make sure that the ';' handling especially for '};' sequences 
		// only applies to the join points and not the content of the fragments (initialization expressions. 
		// That is the reason why the join is done using '#' instead 
		return code.join("#" + System.getProperty("line.separator")).replace("}#","}").replace("#",";")
		
	}
	
	protected def raiseLocalOutEvent(EventRaisingExpression it, ExpressionsGenerator exp) {
		val localOutEvent = event.definition.event.getLocalOutEvent()
		'''
			«localOutEvent.eventMarker»«IF value !== null»;
			«localOutEvent.valueAccess» = «exp.code(value)»«ENDIF»'''
	}
	
	protected def CharSequence eventTrace(EventRaisingExpression it) {
		event.definition.traceCode(if (it.value !== null) '''&«event.definition.event.valueAccess»''' else '''sc_null''')
	}
	
	protected def String eventValue(EventRaisingExpression it, ExpressionsGenerator exp) {
		if (it.value !== null) '''«event.definition.event.valueAccess» = «exp.code(value)»''' else null
	}
	
	protected def CharSequence eventMarker(Event it)
		'''«access» = «TRUE_LITERAL»'''
	
	
	def eventRaiserSignature(ExecutionFlow it, EventDefinition event) '''void «event.asRaiser»(«scHandleDecl»«event.valueParams»)'''
	
	def eventGetterSignature(ExecutionFlow it, EventDefinition event) '''«sc_bool.name» «event.asRaised»(const «scHandleDecl»)'''
	
	def eventValueGetterSignature(ExecutionFlow it, EventDefinition event) '''«event.typeSpecifier.targetLanguageName» «event.asGetter»(const «scHandleDecl»)'''
	
	def eventObservableSignature(ExecutionFlow it, EventDefinition event) '''«sc_observable.name»«event.eventType»* «event.asObservableGetter»(«scHandleDecl»)'''
	
	def eventObserverNextSignature(ExecutionFlow it, EventDefinition event) '''«sc_observable.name»«event.eventType»* «event.asObservableGetter»(«scHandleDecl»)'''
	
	
	override eventClearCode(ExecutionFlow flow, Expression event) '''
		«event.code» = «FALSE_LITERAL»;
	'''
	
	override eventMoveCode(ExecutionFlow flow, Expression source, Expression target) '''
		«target.code» = «source.code»;
		«IF source.event.hasValue»«target._meta(target.event.valueFeature).code» = «source._meta(source.event.valueFeature).code»;«ENDIF»
		«source.code» = «FALSE_LITERAL»;
	'''
	
	override eventNextCode(ExecutionFlow flow) {
		throw new UnsupportedOperationException("Something went wrong - generating 'eventNext' not supported for cycle based statecharts.")
	}
		
	override getNextEventCode(ExecutionFlow it) {
		'''
		«dispatchNextEventFctID»(«scHandle»)'''
	}
		
}