/**
 * Copyright (c) 2020-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.submodules

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.core.templates.TraceCodeGenerator
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ScheduleTimeEvent
import com.yakindu.sct.model.sexec.Trace
import com.yakindu.sct.model.sexec.TraceBeginRunCycle
import com.yakindu.sct.model.sexec.TraceEndRunCycle
import com.yakindu.sct.model.sexec.TraceStateEntered
import com.yakindu.sct.model.sexec.TraceStateExited
import com.yakindu.sct.model.sexec.UnscheduleTimeEvent
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.VariableDefinition

import static com.yakindu.sct.generator.c.CGeneratorConstants.*

/**
 * @author axel terfloth
 */
class TraceCode extends TraceCodeGenerator {
	
 	@Inject extension GenmodelEntries
 	@Inject extension Naming
 	@Inject extension CTypes
  		

	def dispatch CharSequence traceCode(Trace it) '''
		«callTraceHook»
		«IF (entry.tracingGeneric)»«notifyTrace»«ENDIF»
	'''


	override dispatch CharSequence traceCode(Object it) {
		if (entry.tracingGeneric) notifyTrace else ''''''
	}

	def CharSequence traceCode(Object it, Object value) {
		if (entry.tracingGeneric) it.notifyTrace(value) else null
	}

	def CharSequence traceTimeEventRaised(ExecutionFlow it) {
		if (entry.tracingGeneric) '''
			{
				«sc_integer.name» tev_id = time_event_index(«scHandle», evid);
				«it.traceFctID»_TIME_EVENT(«scHandle», «TRACE_MACHINE_TIME_EVENT_RAISED», tev_id);
			}
		'''
	}
	

	//def protected dispatch notifyTrace(Object it) ''''''
	
	def protected dispatch notifyTrace(VariableDefinition it) '''«flow.tracingPrefix»FEATURE(«scHandle», «TRACE_MACHINE_VARIABLE_SET», «featureEnumMemberName», &«access»)'''
	
	def protected dispatch notifyTrace(Object it, Object value) '''// failed attempt to trace ... '''
	
	def protected dispatch notifyTrace(VariableDefinition it, Object value) 
		'''«flow.tracingPrefix»FEATURE(«scHandle», «TRACE_MACHINE_VARIABLE_SET», «featureEnumMemberName», «value»)'''

	def protected dispatch notifyTrace(EventDefinition it, Object value) 
		'''«flow.tracingPrefix»FEATURE(«scHandle», «TRACE_MACHINE_EVENT_RAISED», «featureEnumMemberName», «value»)'''


	def protected dispatch notifyTrace(TraceBeginRunCycle it) '''
		«flow.traceFctID»(«scHandle», «TRACE_MACHINE_CYCLE_START»);
	'''

	def protected dispatch notifyTrace(TraceEndRunCycle it) '''
		«flow.traceFctID»(«scHandle», «TRACE_MACHINE_CYCLE_END»);
	'''


	def protected dispatch notifyTrace(TraceStateEntered it) '''
		«TRACE_CALL»_STATE(«scHandle», «TRACE_MACHINE_ENTERED», «state.stateName»);
	'''

	def protected dispatch notifyTrace(TraceStateExited it) '''
		«TRACE_CALL»_STATE(«scHandle», «TRACE_MACHINE_EXITED», «state.stateName»);
	'''

	def protected dispatch notifyTrace(ScheduleTimeEvent it) '''
		«TRACE_CALL»_TIME_EVENT(«scHandle», «TRACE_MACHINE_TIME_EVENT_SET», «flow.timeEvents.indexOf(timeEvent)»);
	'''
	
	def protected dispatch notifyTrace(UnscheduleTimeEvent it) '''
		«TRACE_CALL»_TIME_EVENT(«scHandle», «TRACE_MACHINE_TIME_EVENT_UNSET», «flow.timeEvents.indexOf(timeEvent)»);
	'''

	def protected dispatch callTraceHook(Trace it) '''''' 

	def protected dispatch callTraceHook(TraceStateEntered it) '''
		«IF entry.tracingEnterState»
			«flow.enterStateTracingFctID»(«scHandle», «it.state.stateName»);
		«ENDIF»
	'''

	def protected dispatch callTraceHook(TraceStateExited it) '''
		«IF entry.tracingExitState»
			«flow.exitStateTracingFctID»(«scHandle», «it.state.stateName»);
		«ENDIF»
	'''
	
	
	override traceEnterCode(ExecutionFlow it) {
		if (entry.tracingGeneric) '''
			«it.traceFctID»(«scHandle», «TRACE_MACHINE_ENTER»);
		'''	
	}
	
	
	override traceExitCode(ExecutionFlow it) {
		if (entry.tracingGeneric) '''
			«it.traceFctID»(«scHandle», «TRACE_MACHINE_EXIT»);
		'''
	}
	
	
}