/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.submodules.eventdriven

import com.google.inject.Inject
import com.yakindu.sct.generator.c.CGeneratorConstants
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.c.IHeaderFragment
import com.yakindu.sct.generator.c.extensions.EventNaming
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgen.GeneratorEntry

class EventDrivenStatemachineHeaderFragment implements IHeaderFragment {
	@Inject protected extension EventQueue
	@Inject protected extension Naming
	@Inject protected extension SExecExtensions
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension INamingService
	@Inject extension EventNaming
	@Inject extension EventDrivenStatechartTypes
	@Inject protected extension GeneratorPredicate
	
	override defines(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
		'''
		«IF requiresEventQueue»
		#ifndef «queueBufferSize»
		#define «queueBufferSize» «CGeneratorConstants.EVENT_QUEUE_BUFFER_SIZE»
		#endif
		«ENDIF»
		«IF requiresIncomingEventQueue»
		#ifndef «inBufferSize»
		#define «inBufferSize» «queueBufferSize»
		#endif
		«ENDIF»
		«IF requiresInternalEventQueue»
		#ifndef «internalBufferSize»
		#define «internalBufferSize» «queueBufferSize»
		#endif
		«ENDIF»
		#ifndef «invalidEvent»
		#define «invalidEvent» 0
		#endif
		'''
	}
	
	override fileComment(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
		''''''
	}
		
	override forwardDeclarations(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
		''''''
	}
	
	override functions(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
		''''''
	}
	
	override includes(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
		''''''
	}
	
	override types(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
		'''
		«IF needsValueUnion»
		«generateEventValueUnion»
		«ENDIF»

		«IF requiresEventQueue»
		«generateEventsEnum»
		
		«generateEventStruct»
		«ENDIF»
		
		«IF requiresEventQueue»
		«generateEventQueue»
		
		«ENDIF»
		'''
	}
}
