/**
 * Copyright (c) 2016-2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * László Kovács - itemis AG
 * 
 */

package com.yakindu.sct.generator.c.typesystem

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.base.types.annotations.TypeAnnotations
import com.yakindu.base.types.typesystem.GenericTypeValueProvider
import com.yakindu.base.types.typesystem.ITypeValueProvider
import com.yakindu.sct.generator.c.types.CTypeAnnotations
import com.yakindu.sct.generator.c.types.CTypeSystemAccess
import com.yakindu.sct.model.sruntime.Any

import static com.yakindu.sct.types.lib.StatechartLibrary.*

/**
 * @author andreas muelder - Initial contribution and API
 * @author laszlo kovacs - Exntension for custom contributed types
 * 
 */
class CTypeValueProvider extends GenericTypeValueProvider implements ITypeValueProvider {

	@Inject protected extension TypeAnnotations
	@Inject protected extension CTypeAnnotations
	@Inject protected extension CTypeSystemAccess

	static val STM_TYPES = #[EVENT_DRIVEN_NAME,CYCLE_BASED_NAME,STATEMACHINE_NAME]

	override defaultValue(Type type) {
		val originType = type.getOriginType()

		if (is(originType, CTypeSystem.UNSUPPORTED_TYPE) || is(originType, CTypeSystem.ANY)) {
			return new Any();
		}
		
		if(originType instanceof ComplexType){
			if (originType.features.filter(Property).exists[typeSpecifier.type.pointerType] || originType.isValueType)
				return null
		}
		
		if(type.isCUnion || type.superTypes.exists[superType | superType.type.isCUnion])
			return null
			
		if (!originType.hasBuiltInTypeAnnotation && !originType.stateMachineType && !(type instanceof EnumerationType)) {
			if (type instanceof ComplexType) {
				if (type.features.forall[type !== null]){
					val typesList = type.features.filter(Property).map[p| 
						if(p.type !== type) p.type.defaultValue
					].filter(o|o !== null).toList
					if(typesList.nullOrEmpty) return null
					else return typesList
				}					
			}
		}

		return super.defaultValue(originType);
	}
	
	def isStateMachineType(Type it){
		superTypes.exists[ts | ts.type.hasBuiltInTypeAnnotation || STM_TYPES.exists[n | ts.type.name.equals(n)]]
	}
}