/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.qt.codemodel

import com.yakindu.base.types.AnnotatableElement

/**
 * Used for specifying Qt specific member types.
 * 
 * Currently signal and slot is supported.
 * 
 * @author axel terfloth
 */
class QtMemberTypeAnnotations {

	public static String SIGNAL_ANNOTATION = "__signal__"
	public static String SLOT_ANNOTATION = "__slot__"

	def isSignal(AnnotatableElement it) {
		getAnnotationOfType(SIGNAL_ANNOTATION) !== null
	}

	def isSlot(AnnotatableElement it) { getAnnotationOfType(SLOT_ANNOTATION) !== null }

}
