/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Axel Terfloth - itemis AG
*
*/
package com.yakindu.sct.generator.cpp.qt.features

import com.yakindu.sct.generator.cpp.features.CPPDefaultFeatureValueProvider
import com.yakindu.sct.generator.cpp.features.CPPFeatureConstants
import com.yakindu.sct.model.sgen.FeatureParameterValue
import com.yakindu.sct.model.sgen.FeatureType
import org.eclipse.core.runtime.IStatus
import org.eclipse.emf.ecore.EObject
import org.eclipse.core.runtime.Status
import com.yakindu.sct.model.sgen.FeatureConfiguration

/**
 * 
 * @author terfloth
 *
 */
class QtCoreLibraryDefaultFeatureValueProvider extends CPPDefaultFeatureValueProvider {
	
	override setDefaultValue(FeatureType featureType, FeatureParameterValue parameterValue,
			EObject contextElement) {
		super.setDefaultValue(featureType, parameterValue, contextElement);
		if (parameterValue.getParameter().getName().equals(CPPFeatureConstants.SMART_POINTERS)) {
			parameterValue.setValue(true);
		}
	}
	
	override IStatus validateParameterValue(FeatureParameterValue parameter) {
		val superResult = super.validateParameterValue(parameter); 
		if (superResult != Status.OK_STATUS) {
			return superResult;
		}
		val parameterName = parameter.getParameter().getName();
		if (CPPFeatureConstants.SMART_POINTERS.equals(parameterName)) {
			if (!parameter.booleanValue) {
				return error("The Qt generator requires smart pointers");
			}
		}
		return Status.OK_STATUS;		
	}
	
	
	/** The Qt code generator does not define any constraint for the out event API as as signals are always used. */
	override protected validateOutEventApi(FeatureConfiguration configuration) {
		return Status.OK_STATUS
	}	
}