/**
 * Copyright (c) 2018-2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 *
 * Contributors:
 * 	Axel Terfloth - itemis AG
 *
 */
package com.yakindu.sct.generator.cpp.qt.providers

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.providers.StatemachineClassDeclaration
import com.yakindu.sct.generator.cpp.qt.QtNaming
import com.yakindu.sct.generator.cpp.qt.codemodel.QtMemberTypeAnnotations
import com.yakindu.sct.generator.cpp.qt.templates.QtClassDeclaration
import com.yakindu.sct.generator.cpp.templates.ClassDeclaration
import com.yakindu.sct.generator.cpp11.codemodel.CodeModel
import com.yakindu.sct.model.sexec.ExecutionFlow

/**
 * Qt state machine classes also make use of signals and slots. This implementation takes care of those..
 *
 * @author terfloth
 *
 */
class QtStatemachineClassDeclaration extends StatemachineClassDeclaration {
	@Inject protected extension QtNaming
	@Inject protected extension CodeModel
	@Inject protected extension VisibilityAnnotations
	@Inject protected extension QtMemberTypeAnnotations
	@Inject protected extension GeneratorAssignment
	@Inject protected extension CppSpecifiers
	
	/** 
	 * Adds extended constructor declaration as well as declarations for signals and slots. 
	 * Overrides the base class destructively in order to avoid changes to base implementation. 
	 */
	override generateClass(ExecutionFlow it, extension IGenArtifactConfigurations artifactConfigs,
		ClassDeclaration classDecl) {

		super.generateClass(it, artifactConfigs, classDecl)


		if(classDecl instanceof QtClassDeclaration) {
			
			implementationClass.features.filter[isPublic].filter[isSlot].forEach[
				classDecl.slot(
					'''
					«declarationCode» 
					'''
				)
			]
			
			implementationClass.features.filter[isProtected].filter[isSlot].forEach[
				classDecl.protectedSlot(
					'''
					«declarationCode»
					'''
				)
			]
			
			implementationClass.features.filter[isSignal].forEach[
				classDecl.signal(
					'''
					«declarationCode»
					'''
				)
			]			
		}

		classDecl
	}
	
	
	override protected constructors(ClassDeclaration classDecl, boolean noexcept) {
		classDecl
			.constructorDeclaration(#["QObject *parent"], noexcept)
	}
	
	override protected getInterfaceExtensions(ExecutionFlow flow) {
		val extends = super.getInterfaceExtensions(flow)
		extends.add(0, "public QObject")
		extends
	}
	
}