/**
* Copyright (c) 2020 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
*/
package com.yakindu.sct.generator.python

import com.google.inject.Inject
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.model.sgen.FeatureParameterValue
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgen.GeneratorModel
import com.yakindu.sct.model.sgraph.Statechart
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.EcoreUtil

import static com.yakindu.sct.generator.core.library.ICoreLibraryConstants.*
import static com.yakindu.sct.generator.python.features.IPythonFeatureConstants.*

import static extension org.eclipse.xtext.EcoreUtil2.*

class GenmodelEntries {

	@Inject extension StringHelper

	// Features
	
	def private getLicenseFeature(GeneratorEntry it) {
		getFeatureConfiguration(LICENSE_HEADER)
	}

	def private getNamingFeature(GeneratorEntry it) {
		getFeatureConfiguration(NAMING_FEATURE)
	}

	def private getGeneralFeatures(GeneratorEntry it) {
		getFeatureConfiguration(GENERAL_FEATURES)
	}
	
	def private getPyPackagingFeatures(GeneratorEntry it) {
		getFeatureConfiguration(FEATURE_PYPACKAGING)
	}
	

	// Paramter : Naming
	
	def FeatureParameterValue getBasePackageParameter(GeneratorEntry it) {
		namingFeature?.getParameterValue(BASE_PACKAGE)
	}
	
	def private FeatureParameterValue getLibraryPackageParameter(GeneratorEntry it) {
		namingFeature?.getParameterValue(LIBRARY_PACKAGE)
	}
	
	// Paramter : License
	
	def private FeatureParameterValue getLicenseTextParameter(GeneratorEntry it) {
		licenseFeature?.getParameterValue(LICENSE_TEXT)
	}

	// Parameter : General
	
	def private FeatureParameterValue getRuntimeTemplateParamter(GeneratorEntry it){
		generalFeatures?.getParameterValue(RUNTIME_TEMPLATE)
	}
	
	def private FeatureParameterValue getUseDefaultTimer(GeneratorEntry it){
		generalFeatures?.getParameterValue(DEFAULT_TIMER)	
	}
	
	
	// Parameter : Python Packaging
	
	def private FeatureParameterValue getCreatePyPackageFiles(GeneratorEntry it){
		pyPackagingFeatures?.getParameterValue(PYPACK_CREATEFILES)
	}
	
	def private FeatureParameterValue getPyPackageAuthorParameter(GeneratorEntry it){
		pyPackagingFeatures?.getParameterValue(PYPACK_AUTHOR)
	}
	
	def private FeatureParameterValue getPyPackageVersionParameter(GeneratorEntry it){
		pyPackagingFeatures?.getParameterValue(PYPACK_VERSION)
	}
	
	def private FeatureParameterValue getPyPackageShortDescriptionParameter(GeneratorEntry it){
		pyPackagingFeatures?.getParameterValue(PYPACK_DESCRIPTION)
	}
	
	def private FeatureParameterValue getPyPackageLicenseParameter(GeneratorEntry it){
		pyPackagingFeatures?.getParameterValue(PYPACK_LICENSE)
	}
	
	def private FeatureParameterValue getPyPackageURLParameter(GeneratorEntry it){
		pyPackagingFeatures?.getParameterValue(PYPACK_URL)
	}
	
	// Getter Section
	
	def getLicenseText(GeneratorEntry it) {
		if (licenseTextParameter !== null) {
			return licenseTextParameter.stringValue.trim
		}
		return "Generated by itemis CREATE code generator."
	}

	def getBasePackage(GeneratorEntry it) {
		((basePackageParameter?.stringValue ?: BASE_PACKAGE_DEFAULT).dot(statechart?.namespace)).toLowerCase
	}
	
	def getBasePackage(GeneratorEntry entry, Statechart context) {
		val contextEntry = (entry.model.entryFor(context) ?: entry)
		((contextEntry.basePackageParameter?.stringValue ?: BASE_PACKAGE_DEFAULT).dot(context.namespace)).toLowerCase
	}
	
	private def getModel(GeneratorEntry it) {
		getContainerOfType(GeneratorModel)
	}
	
	private def entryFor(GeneratorModel it, EObject element) {
		entries.findFirst[EcoreUtil.equals(elementRef, element)]
	}

	def getBasePackagePath(GeneratorEntry it) {
		basePackage.toPath
	}
	
	def getLibraryPackage(GeneratorEntry it) {
		libraryPackageParameter?.stringValue ?: LIBRARY_PACKAGE_DEFAULT
	}

	def createRuntimeTemplate(GeneratorEntry it){
		if (runtimeTemplateParamter !== null){
			return runtimeTemplateParamter.booleanValue
		}
		return false
	}
	
	// Timer
	
	def createDefaultTimer(GeneratorEntry it){
		if (useDefaultTimer !== null){
			return useDefaultTimer.booleanValue
		}
		return false
	}
	
	// PyPackaging
	
	def createPyPackage(GeneratorEntry it){
		if (createPyPackageFiles !== null){
			return createPyPackageFiles.booleanValue
		}
		return false
	}
	
	def getPyPackageAuthor(GeneratorEntry it){
		if (pyPackageAuthorParameter !== null){
			return pyPackageAuthorParameter.stringValue
		}
		return "Marty McFly"
	}
	
	def getPyPackageVersion(GeneratorEntry it){
		if (pyPackageVersionParameter !== null){
			return pyPackageVersionParameter.stringValue
		}
		return "0.1dev"
	}
	
	def getPyPackageDescription(GeneratorEntry it){
		if (pyPackageShortDescriptionParameter !== null){
			return pyPackageShortDescriptionParameter.stringValue
		}
		return "Enter your short description here."
	}
	
	def getPyPackageLicense(GeneratorEntry it){
		if (pyPackageLicenseParameter !== null){
			return pyPackageLicenseParameter.stringValue
		}
		return "Enter your license text here. You don't know what license to choose? Take a look at https://choosealicense.com/ ."
	}
	
	def getPyPackageURL(GeneratorEntry it){
		if (pyPackageURLParameter !== null){
			return pyPackageURLParameter.stringValue
		}
		return "http://pypi.python.org/pypi/"
	}
	
	protected def getStatechart(GeneratorEntry it) {
		if (elementRef instanceof Statechart) 
			elementRef as Statechart
		else
			null as Statechart
	}
	
}
