/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.python

import com.google.inject.Inject
import com.yakindu.sct.generator.core.IExecutionFlowGenerator
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.python.files.DefaultTimer
import com.yakindu.sct.generator.python.files.PyPSetup
import com.yakindu.sct.generator.python.files.RXPython
import com.yakindu.sct.generator.python.files.RuntimeTemplate
import com.yakindu.sct.generator.python.files.Statemachine
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * Python code generator main class. 
 * 
 * @author Markus Muehlbrandt - Initial contribution and API
 * @author Axel Terfloth - extensions
 * @author Norbert M. Lang - Adapted to Python Generator
 * 
 */
class PythonGenerator implements IExecutionFlowGenerator {
	
	@Inject extension GenmodelEntries
	@Inject extension SExecExtensions
	@Inject extension ICoreLibraryHelper
	@Inject extension ShadowEventExtensions

	@Inject extension DefaultTimer
	@Inject extension RXPython
	@Inject extension RuntimeTemplate
	@Inject extension PyPSetup
	@Inject extension Statemachine 

	@Inject INamingService namingService

	override generate(ExecutionFlow flow, GeneratorEntry entry, ISCTFileSystemAccess fsa) {
		
		namingService.initializeNamingService(flow);
		
		if (flow.timed) {
			if (entry.createDefaultTimer) {
				flow.generateTimer(entry, fsa)
			}
		}
		
		if (entry.createPyPackage) {
			flow.generatePythonPackagingSetup(entry, fsa)
		}
		
		if (entry.createRuntimeTemplate) {
			flow.generateRuntimeTemplate(entry, fsa)
		}
		
		if (entry.outEventObservablesUsed && flow.hasOutgoingEvents || !flow.shadowEvents.nullOrEmpty) {
			flow.generateObserver(entry, fsa)
		}
		
		flow.generateStatemachine(entry, fsa)
	}
}
