/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.python.files

import com.google.inject.Inject
import com.yakindu.sct.generator.python.GenmodelEntries
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

/**
 * 
 * @author Norbert M. Lang - initial contribution
 * 
 */

class RuntimeTemplate {
	
	@Inject extension Naming
	@Inject extension GenmodelEntries
	@Inject extension SExecExtensions

	def generateRuntimeTemplate(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
		var filename = entry.basePackagePath + '/' + 'default_runtime'.py
		var content = content(entry, flow)
		fsa.generateFile(filename, content)
	}
	
	def private content(GeneratorEntry entry, ExecutionFlow flow)'''		
		"""
		«entry.licenseText»
		
		This is a default template of a runtime environment for a
		generated statemachine. It needs custom code to act like
		intended, e.g. include methods to raise events etc.
		
		"""
		
		«entry.createImports(flow)»
		
		class «flow.statemachineName»Runtime:
			
			def __init__(self):
				self.sm = «flow.statemachineName»()
				«IF flow.timed»
					self.ti = Timer()
				«ENDIF»
				# Enter custom init code here..
				
				
			"""
			Enter custom methods here..
			"""
			
			
			def setup(self):
				""" Get statemachine ready and enter it.
				"""
				«IF flow.timed»
					self.sm.timer_service = self.ti
				«ENDIF»
				self.sm.init()
				self.sm.enter()
				
			def run(self):
				""" Include your interface actions here
				"""
				while True:
					# enter what you like to do
					self.sm.run_cycle()
				
			def shutdown(self):
				""" Unset timer and exit statemachine.
				"""
				print('State machine shuts down.')
				«IF flow.timed»
					self.sm.unset_timer()
				«ENDIF»
				self.sm.exit()
				print('Bye!')
				
				
		if __name__ == "__main__":
			sr = «flow.statemachineName»Runtime()
			sr.setup()
			sr.run()
			sr.shutdown()
	'''
	
	def private createImports(GeneratorEntry entry, ExecutionFlow flow) '''
		import sys, os
		sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))
		from «flow.statemachineName.toLowerCase».«flow.statemachineClassName» import «flow.statemachineName»
		«IF flow.timed»
			from «flow.statemachineName.toLowerCase».timer.«Timer» import Timer
		«ENDIF»
	'''
}
