/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.python.submodules

import com.google.inject.Inject
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.generator.python.naming.Naming

class TimingFunctions {
	
	@Inject extension SExecExtensions
	@Inject extension Naming
	
	def timingFunctions(ExecutionFlow flow) '''
		«IF flow.timed»
			def time_elapsed(self, event_id):
				""" Mark the corresponding time event as True.
				"""
				if event_id in range(«flow.timeEvents.size»):
					self.«timeEvents»[event_id] = True
		«ENDIF»
	'''
}