/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */
package com.yakindu.sct.generator.python.submodules

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sexec.extensions.SExecExtensions

class TypeCode {

	@Inject extension ICodegenTypeSystemAccess
	@Inject extension Naming
	@Inject extension SExecExtensions

	def dispatch CharSequence toCode(ComplexType it) '''
		class «targetLanguageName»:
			"""Implementation of internal scope.
			"""
			
			def __init__(self«FOR prop : features.filter(Property)», «prop.identifier»«ENDFOR»):
				«features.map[toCode].join»
		
	'''

	def dispatch CharSequence toCode(Event event) '''
		self.«event.identifier» = False
		«IF event.hasValue»
			self.«event.valueIdentifier» = None
		«ENDIF»
	'''

	def dispatch CharSequence toCode(Property prop) '''
		self.«prop.identifier» = «prop.identifier»
	'''

}
