package com.yakindu.sct.model.sgraph.naming

import com.google.inject.Inject
import com.yakindu.sct.model.sgraph.Region
import org.eclipse.xtext.naming.QualifiedName

import static extension com.yakindu.sct.model.sgraph.naming.IdentifierConverter.*
import org.eclipse.emf.ecore.EObject
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.base.base.NamedElement
import com.yakindu.sct.model.sgraph.FinalState

class SGraphShortNameProvider extends SGraphNameProvider{
	
	@Inject	protected extension IdentifierConverter
	
	override qualifiedName(Region ele) {
		ele.localNameQualifiedWithParentName
	}
	
	
	override qualifiedName(RegularState it) {
		localNameQualifiedWithParentName
	}
	
	override qualifiedName(FinalState it) {
		localNameQualifiedWithParentName
	}
	

	def protected QualifiedName localNameQualifiedWithParentName(EObject it) {
		val elementName = localName
		val parentFQN = eContainer.fullyQualifiedName
		
		if (parentFQN !== null) {
			if (elementName !== null) {
				return parentFQN.append(elementName)
			} else {
				return parentFQN
			}
		}
		
		return localName
	}	
	
	
	def protected dispatch QualifiedName localName(EObject it) {
		null		
	}
	
	
	def protected dispatch QualifiedName localName(NamedElement it) {

		if ( ! name.nullOrEmpty ) {
			QualifiedName.create(name.toIdentifier)		
		} else {
			null
		}
	}
	
	
	def protected dispatch QualifiedName localName(FinalState it) {
		QualifiedName.create(_FINAL_STATE_NAME)		
	}
	
	
}