/** 
 * Copyright (c) 2022 committers of itemis CREATE and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * Contributors:
 * committers of itemis CREATE - initial API and implementation
 */
package com.yakindu.sct.model.sgraph.util

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Event
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.sgraph.Statechart
import java.util.HashSet
import java.util.Set
import org.eclipse.emf.ecore.EObject

class StatechartUtil {
	
	@Inject extension OriginTracing
	
	def dispatch isOriginStatechart(Type type) {
		type?.originTraces.exists[it instanceof Statechart]
	}
	
	def dispatch isOriginStatechart(EObject it) {
		false
	}
	
	def dispatch isOriginStatechart(Void it) {
		false
	}
	
	def isMultiSM(EObject it) {
		isOriginStatechart || isOriginScope
	}
	
	def dispatch isOriginScope(Type type) {
		type.originTraces.exists[it instanceof Scope]
	}
	
	def dispatch isOriginScope(EObject it) {
		false
	}
	
	def dispatch isOriginScope(Void it) {
		false
	}
	
	def isOriginStateEnum(EObject it) {
		// state enums are enumeration types with an origin trace back to the statechart
		(it instanceof EnumerationType) && originTraces.exists[it instanceof Statechart]
	}
	
	def Statechart getOriginStatechart(EObject it) {
		if(originTraces.filter(Statechart).head !== null)
			return originTraces.filter(Statechart).head as Statechart
		else if(origin !== null)
			(origin as EObject).getOriginStatechart
		else return null
	}
	
	def getOriginState(EObject it) {
		originTraces.filter(RegularState).head
	}
	
	def getOriginScope(EObject it) {
		originTraces.filter(Scope).head
	}
	
	def getOriginEvent(EObject it) {
		originTraces.filter(Event).head
	}
	
	def referencedStatecharts(EObject it) {
		val Set<Statechart> resultSet = new HashSet
		
		eAllContents.forEach[collectReferencedStatecharts(resultSet)]
		
		return resultSet
	}
	
	
	def protected dispatch void collectReferencedStatecharts(EObject it, Set<Statechart> resultSet) {}


	def protected dispatch void collectReferencedStatecharts(TypedDeclaration it, Set<Statechart> resultSet) {
		type.collectReferencedStatecharts(resultSet)
	}
	
	def protected dispatch void collectReferencedStatecharts(ElementReferenceExpression it, Set<Statechart> resultSet) {
		reference.collectReferencedStatecharts(resultSet)
	}
	
	def protected dispatch void collectReferencedStatecharts(FeatureCall it, Set<Statechart> resultSet) {
		feature.collectReferencedStatecharts(resultSet)
	}
	
	def protected dispatch void collectReferencedStatecharts(Enumerator it, Set<Statechart> resultSet) {
		eContainer.collectReferencedStatecharts(resultSet)
	}
	
	def protected dispatch void collectReferencedStatecharts(Type it, Set<Statechart> resultSet) {
		it.getOriginStatechart.collectReferencedStatecharts(resultSet)
	}	
	
	def protected dispatch void collectReferencedStatecharts(Statechart it, Set<Statechart> resultSet) {
		resultSet += it
	}
	
	def protected dispatch void collectReferencedStatecharts(Void it, Set<Statechart> resultSet) {}
	
}
