/**
 * Copyright (c) 2012-2022 committers of itemis CREATE and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     committers of itemis CREATE - initial API and implementation
 */
package com.yakindu.sct.model.sgraph.validation;

import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import com.yakindu.sct.model.sgraph.Choice;
import com.yakindu.sct.model.sgraph.Synchronization
import static com.yakindu.sct.model.sgraph.util.SGgraphUtil.areOrthogonal

/**
 * 
 * All validation constraints for the meta model element {@link Choice}
 * 
 */
class ChoiceValidator extends AbstractSGraphValidator {

	public val static CHOICE_TRANSITIONS_REQUIRE_N_OUT_MSG = "A choice must have at least one outgoing transition.";
	public val static CHOICE_TRANSITIONS_REQUIRE_N_OUT_CODE = "choice.transitions.RequireNOut";

	
	@Check(CheckType.FAST)
	def checkChoiceTransitionsRequireNOut(Choice it) {
		if (outgoingTransitions.size == 0) {
			error(CHOICE_TRANSITIONS_REQUIRE_N_OUT_MSG, it, null, -1, CHOICE_TRANSITIONS_REQUIRE_N_OUT_CODE);
		}
	}
	
	public val static CHOICE_FROM_SYNC_DONT_GO_OUT_MSG = "Since this choice targeted from a synchronization node that forks, outgoing transitions must not leave the composite state.";
	public val static CHOICE_FROM_SYNC_DONT_GO_OUT_CODE = "choice.transitions.FromSyncToChoiceNoOutgoingTrans";

	
	@Check(CheckType.FAST)
	def checkChoiceFromSyncDontTargetOutside(Choice it) {
		if (incomingTransitions.exists[t | (t.source instanceof Synchronization) && t.source.outgoingTransitions.size > 2 ] && !areOrthogonal(outgoingTransitions.map[target])) {
			error(CHOICE_FROM_SYNC_DONT_GO_OUT_MSG, it, null, -1, CHOICE_FROM_SYNC_DONT_GO_OUT_CODE);
		}
	}

}
