/**
 * Copyright (c) 2023-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.artifacts

import com.google.inject.Inject
import com.itemis.create.base.generator.core.artifacts.SourceFile
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * Defines the artifact type of a C# file and implements the proper interface for integration into the CREATE code generator infrastructure.
 * 
 * @author Axel Terfloth
 */
class CSharpFile extends SourceFile {
	
	@Inject protected GeneratorEntry entry
	@Inject protected extension CsharpGenmodelEntries
	
	override fileExtension() '''«IF entry.getgeneratedFileExtension»g.«ENDIF»cs'''
		
	override content() {
		'''
			«entry.licenseText»
			
			«entry.compilerPragma»

			«compilationUnit.definitionCode»
			
		'''
	}
}