/**
 * Copyright (c) 2023-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.artifacts

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.artifacts.IContent
import com.itemis.create.base.generator.core.artifacts.IGenArtifact
import com.itemis.create.base.generator.core.concepts.TimedInterface
import com.itemis.create.base.generator.csharp.codepattern.CsharpLiterals
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * @author laszlo kovacs- Initial contribution.
 */
@Singleton
class CsharpITimed implements IContent, IGenArtifact {
	
	@Inject protected extension TimedInterface
	@Inject protected extension CsharpLiterals
	@Inject protected GeneratorEntry entry
	@Inject protected extension CsharpGenmodelEntries
		
	override content() '''
	namespace «entry?.getTimerLibraryPackage»{
		public interface ITimed
	    {
	        /// <summary>
	        /// Callback method if a time event occurred.
	        /// </summary>
	        /// <param name="eventID">The id of the occurred event.</param>
	        «raiseTimeEventOp.typeSpecifier.asLiteral» «raiseTimeEventOp.name»(«FOR p:raiseTimeEventOp.parameters SEPARATOR ", "»«p.typeSpecifier.asLiteral» «p.name»«ENDFOR»);
	
	        /// <summary>
	        /// Set the ITimerService for the state machine. It must be set
	        /// externally on a timed state machine before Enter() is called.
	        /// </summary>
	        /// <param name="timerService">The timer service implementation to be set.</param>
	        void SetTimerService(ITimerService timerService);
	    }
	}
	'''
}