/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.artifacts

import com.itemis.create.base.generator.core.artifacts.IContent
import com.itemis.create.base.generator.core.artifacts.IGenArtifact

/**
 * Translates the common format specifier usage of the logger to data binding style and prints to the standard console
 * 
 * @author laszlo kovacs - Initial contribution
 */
class CsharpLogger implements IContent, IGenArtifact{
	override content()'''
	    public static class Logger
	    {
	        public static void Write(string format, params object[] args)
	        {
	            int index = 0;
	            string dotnetFormat = System.Text.RegularExpressions.Regex.Replace(
	                format, 
	                @"%[a-zA-Z]", 
	                (match) => "{" + (index++) + "}"
	            );
	    
	            Console.WriteLine(dotnetFormat, args);
	        }
	    }
	'''
}