/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.codemodel.CompilationUnit
import com.itemis.create.base.generator.csharp.codepattern.CompilationUnitCode
import com.yakindu.base.types.Package

/**
 * Defines the code model concept of a C# compilation unit. A compilation unit is a collection of declarations
 * which should be placed in a single C# source file. A compilation unit model element is a Package which is annotated as 
 * compilation unit. This concept definition provides a builder to create a properly defined element including generator assignment
 * and a query to check if a package element represents a compilation unit. 
 * 
 * @author Axel Terfloth
 */
@Singleton
class CsharpCompilationUnit extends CompilationUnit {

	@Inject protected extension CompilationUnitCode
	@Inject protected extension CsharpNamespace

	public static final String CSHARP_COMPILATION_UNIT = "__csharp_compilation_unit__"

	override protected compilationUnitAnnotationName() {
		CSHARP_COMPILATION_UNIT
	}
	
	override protected compilationUnitDefinitionGenerator(Package it) {
		compilationUnitCode
	}
	
	override protected provideNamespaceConcept() {
		_csharpNamespace
	}
	
}
