/**
 * Copyright (c) 2023-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.csharp.codepattern.NamespaceCode
import com.yakindu.base.types.Package
import com.yakindu.base.types.TypeBuilder
import com.itemis.create.base.generator.core.codemodel.Namespace

/**
 * A specialization of a namespace which provides a C# specific generator assignment.
 * 
 * @author Axel Terfloth
 */
class CsharpNamespace extends Namespace {
	
	@Inject protected extension TypeBuilder
	@Inject protected extension GeneratorAssignment
	@Inject protected extension NamespaceCode
	
	override protected namespaceGenerator(Package it) {
		namespaceCode
	}
	
}