/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.yakindu.base.types.Package

/**
 * Defines the standard code pattern for generating C# compilation units.
 * 
 * @author Axel Terfloth
 */
class CompilationUnitCode {
	
	@Inject protected extension GeneratorAssignment
	
	def compilationUnitCode(Package cu) '''
	
	«FOR imp : cu.imports»
	using «imp»;
	«ENDFOR»
	
	«FOR m : cu.member»
		«m.definitionCode»
	«ENDFOR»
	
	'''
}