/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.concepts

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.typesystem.ITypeSystem
import org.eclipse.emf.ecore.EObject

/**
 * An event raiser is a method that raises an event on an object. 
 * This method is part of the implementation of an event in the target language. 
 * It is called by client objects. 
 * 
 * @author Axel Terfloth
 */
@Singleton
class EventRaiser {
	
	@Inject protected extension TypeBuilder
	@Inject protected extension ITypeSystem
	
	//TODO: Should be moved to a common place as not only Csharp should use this
	/** 
	 * This methods defines an event raiser for an event and adds it as a sibling.
	 */
	def create r : _op defineEventRaiser(TypedDeclaration it) {
		
		r.name = '''raise«name.toFirstUpper»'''
		r.typeSpecifier = _typeSpecifier(_void)
		if (it.typeSpecifier !== null && type !== getType('void')) {
			r._param("value", it.typeSpecifier.copy)
		} 
//		else if(!it.metaFeatures.filter(Operation).nullOrEmpty){
//			r.metaFeatures += it.metaFeatures.filter(Operation).head
//		} 
		else if (!it.metaFeatures.filter(Property).nullOrEmpty) {
			r._param("value", it.getMetaValue.copy)
		}
		it.addSibling(r)
	}
	
	/** 
	 * Defines an event raiser for each incoming event defined by this complex type.
	 */
	def void defineEventRaiser(EObject it) {
		eAllContents
			.filter(Event)
			//TODO: This should be re-added when moved to a common place
			//.filter[ direction === Direction.IN ]
			.toList
			.forEach[
				defineEventRaiser
			]	
	}
	
	/**
	 * Returns the event raiser for an event if it is defined or null if it is not defined yet.
	 */
	def eventRaiser(TypedDeclaration it) {
		_createCache_defineEventRaiser.get(#[it])	
	}
	
	def getMetaValue(TypedDeclaration e) {
		e.metaFeatures.filter(TypedDeclaration).head.typeSpecifier
	}
	
}