package com.itemis.create.base.generator.csharp.concepts

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.types.resource.Statechart2TypeTransformation

@Singleton
class OutEventHandler {

	@Inject protected extension TypeBuilder
	@Inject protected extension CsharpTypeBuilder
	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE

	@Inject protected extension GeneratorAssignment
	@Inject protected extension OriginTracing
	@Inject protected extension OutEventSubscriber
	@Inject protected extension Literals
	@Inject protected extension EventRaiser
	@Inject protected extension Statechart2TypeTransformation

	def create it : _op(oe.name + 'Handler', _void) defineHandlerForEvent(TypedDeclaration oe) {
		_handler
		_private
		traceOrigin(oe.outEventSubscriber)
		generateDefinitionWith[
			'''
				private void «oe.name.toFirstUpper»Handler(«oe.calcSender» sender, «IF oe.type !== null»«oe.calcEventArgs»«ENDIF»EventArgs e){
					«oe.eventRaiser.name»(«IF !oe.metaFeatures.nullOrEmpty»e.Payload«ENDIF»);
				}
			'''
		]

	}

	def handlerForEvent(TypedDeclaration it) {
		_createCache_defineHandlerForEvent.get(#[it])
	}
	
	def calcSender(TypedDeclaration oe){
		val sender = oe.originTraces.filter(TypedDeclaration).map[type].filterNull.filter[isStatechartType].head as ComplexType		
		return sender.asLiteral + sender.getIfaceForEvent(oe.origin)
	}
	
	def private getIfaceForEvent(ComplexType stmType, Object ev){
		val stmTypeEv = stmType.eAllContents.filter[it.origin === ev].head
		if(stmTypeEv.isInNamedIface){
			return ".I" + stmType.eAllContents.filter(Property).filter[type === stmTypeEv.eContainer].head.name
		} else
			return ""
		
	}
	
	def protected calcEventArgs(TypedDeclaration oe){
		if(oe.type !== null){
			//oe is a shadow event, derived from child stm
			if(!oe.originTraces.filter(Property).nullOrEmpty){
				val childStm = oe.originTraces.filter(Property).head.type as ComplexType
				//TODO: Source out naming convention for EventArgs
				return childStm.asLiteral + "." + childStm.features.filter[originSource == oe.originSource].head.name.toFirstUpper
			}
			else
				return oe.asLiteral + "." + oe.name.toFirstUpper
		}
	}
}
