/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.concepts

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Event
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing

/**
 * An out event subscriber is a method that adds an operation for an out event on an object. 
 * This method is part of the implementation of an event in the target language. 
 * It is called by client objects. 
 * 
 * @author Laszlo Kovacs
 */
@Singleton
class OutEventSubscriber {
	@Inject protected extension TypeBuilder
	@Inject protected extension OriginTracing
	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	
	//TODO: Use this to first define the event subscribe based on the event.
	/** 
	 * This methods defines an event raiser for an event and adds it as a sibling.
	 */
	def create r : _op defineOutEventSubscriber(TypedDeclaration it) {
		
		r.name = '''subscribeTo«name.toFirstUpper»'''
		r.typeSpecifier = _typeSpecifier(_void)
		if (it.typeSpecifier !== null) {
			r._param("handlerToRegister", createTypeSpecifier => [ts |
				ts.type = createType => [ t |
					t.name = name.toFirstUpper + "Handler"
				]
			])
		}	
	}
	
	/** 
	 * Defines an event raiser for each incoming event defined by this complex type.
	 */
	def void defineOutEventSubscriber(Declaration it) {
		eAllContents
			.filter(Event)
			.filter[ direction === Direction.OUT ]
			.toList
			.forEach[ev | (ev.origin as Event).defineOutEventSubscriber => [ op |
				ev.addSibling(op)
			]]	
	}
	
	/**
	 * Returns the event raiser for an event if it is defined or null if it is not defined yet.
	 */
	def outEventSubscriber(TypedDeclaration it) {
		_createCache_defineOutEventSubscriber.get(#[it])	
	}
	
}