package com.itemis.create.base.generator.csharp.transformation

import com.google.inject.Inject
import com.itemis.create.base.generator.csharp.codemodel.CsharpClass
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.ExpressionsFactory
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.Part
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.Statement
import com.yakindu.sct.model.sexec.concepts.EventProcessing

class ClearOutEventsTransformation {
	
	@Inject protected extension EventProcessing
	@Inject protected extension ExpressionExtensions
	@Inject protected extension CsharpClass
	@Inject protected extension ExpressionBuilder
	@Inject protected extension StatemachineClass
	
	protected extension ExpressionsFactory expFactory = ExpressionsFactory.eINSTANCE
	
	def transformClearOutEventOperation(ExecutionFlow it){
		if(clearOutEvents !== null){
			clearOutEvents.eAllContents.filter(Statement).filter[expression instanceof ElementReferenceExpression].forEach[st |
				if(st.expression.featureOrReference.eContainer.isCsharpInterface){
					val prop = st.expression.featureOrReference
					st.expression = prop.stateMachineClass.features.filter(Part).filter[p | p.type === prop.eContainer].head._ref._dot(prop)
				}				
			]
			
			stateMachineClass.features += clearOutEvents
		}
	}
}