/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.transformation

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.itemis.create.base.generator.csharp.codemodel.CsharpClass
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.codepattern.ClassCode
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.BlockExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.AnnotatableElement
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Event
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Part
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedElement
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.core.codemodel.StatemachineEvents
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.concepts.EventBuffer
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import org.eclipse.emf.ecore.util.EcoreUtil

import static com.yakindu.sct.model.sexec.concepts.EventProcessing.CLEAR_IN_EVENTS
import java.util.ArrayList
import com.yakindu.base.types.ArrayTypeSpecifier

/**
 * There are different event buffers defined in the SExec level, which 
 * 
 * @author Laszlo Kovacs
 */
@Singleton
class EventBufferTransformation {
	
	@Inject protected extension EventBuffer
	@Inject protected extension IMethodCode
	@Inject protected extension EventProcessing
	@Inject protected extension StatemachineClass
	@Inject protected extension TypeBuilder
	@Inject protected extension GeneratorAssignment
	@Inject protected extension ClassCode
	@Inject protected extension IVariableCode
	@Inject protected extension StatemachineEvents
	@Inject protected extension SExecExtensions
	@Inject protected extension OriginTracing
	@Inject protected extension ExpressionExtensions
	@Inject protected extension ExpressionBuilder
	@Inject protected extension NamedInterfaceClasses
	@Inject protected extension CsharpClass
	@Inject protected extension CsharpTypeBuilder
	
	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	
	def transformEventBuffer(ExecutionFlow it){
		val smClass = stateMachineClass
		
		smClass.features += smClass.createClearInEvents => [op | op.traceOrigin(clearInEvents)]
		
		if(hasEventBuffer){
			val transformedEvBuf = (eventBuffer.type as ComplexType).addEvBufTypesToExecFlow(it).createTransformedEventBuffer(smClass) => [_private]
			//References for ev buf should be redirected here
			substitueEvBufInExecFlow(transformedEvBuf)
			smClass.features += transformedEvBuf
			smClass.features += it.defineSwapInEventsOp => [ op |
				op._private
				op.addExprForEventValueAssignement(smClass)
				op.traceOrigin(swapIncomingEvents)
				//TODO: Re-evaluate whether this is needed or not
				op.substitueMethodMember(smClass)				
				op.generateDefinitionWith[op.methodDefinitionCode]
			]
			smClass.features += it.defineSwapInternalEventsOp => [ op |
				op._private
				op.traceOrigin(swapInternalEvents)
				//TODO: Re-evaluate whether this is needed or not
				op.substitueMethodMember(smClass)				
				op.generateDefinitionWith[op.methodDefinitionCode]
			]
		}
		smClass.features += it.defineClearInternalEventsOp => [ op |
				op._private
				op.traceOrigin(clearInternalEvents)
				//TODO: Re-evaluate whether this is needed or not
				op.substitueMethodMember(smClass)				
				op.generateDefinitionWith[op.methodDefinitionCode]
			]
		if(clearCurrentInEvents !== null){
			smClass.features += it.defineClearCurrentEventsOp => [ op |
				op._private
				op.traceOrigin(clearCurrentInEvents)
				//TODO: Re-evaluate whether this is needed or not
				op.substitueMethodMember(smClass)				
				op.generateDefinitionWith[op.methodDefinitionCode]
			]
		}
	}
	
	def create i : _csharpClass(evBuf.name) createTransformedEventBuffer(ComplexType evBuf, ComplexType smClass){
		i._public
		i.traceOrigin(evBuf)
		evBuf.annotations.forEach[
			i.annotations += it.copy	
		] 
		evBuf.features.filter(TypedElement).forEach[f |
			if(f instanceof Property) i.features += _part(f.name, f.type) => [iFaceMember |
				iFaceMember.traceOrigin(f)
				iFaceMember._public
				iFaceMember.generateDefinitionWith[ iFaceMember.variableDeclarationCode]
			]
			if(f instanceof Event){
				if(f.getStatemachineEvent(smClass) !== null){
					i.features += f.getStatemachineEvent(smClass).copy => [eventRaised |
						eventRaised.annotations.clear
						eventRaised.traceOrigin(f)
						eventRaised._public
						eventRaised.name = f.name;
						(eventRaised as Property).generateDefinitionWith[(eventRaised as Property).variableDeclarationCode]
					]
				} else {
					i.features += _variable(f.name, _boolean) => [timeEvent |
						timeEvent.traceOrigin(f)
						timeEvent._public;
						(timeEvent as Property).generateDefinitionWith[(timeEvent as Property).variableDeclarationCode]
					]
				}
				if(f.hasValue || f.hasMetaValue){
					i.features += f.getStatemachineEventValue(smClass).copy => [eventValue |
						eventValue.annotations.clear
						eventValue._public;
						(eventValue as Property).generateDefinitionWith[ (eventValue as Property).variableDeclarationCode]
					]
				}
			}
			if(f.type !== null && f.type.isEventBuffer) {
				i.features += (f.type as ComplexType).createTransformedEventBuffer(smClass)
			}
		]
	}
	
	def dispatch getStatemachineEventValue(Event e, ComplexType smClass){
		e.scope.scopeClass.features.filter[name == e.eventValueVariable].head
	}
	
	def dispatch getEventBufferEventValue(Property e, ComplexType smClass){
		smClass.getEventBufferType.eAllContents.filter(NamedElement).filter[name == e.name].head
	}
	
	def dispatch getEventBufferEventValue(Object e, ComplexType smClass){}
	
	def ComplexType getEventBufferType(ComplexType smClass){
		smClass.features.filter(Type).filter[isEventBuffer].head as ComplexType
	}
	
	def addEvBufTypesToExecFlow(ComplexType evBuf, ExecutionFlow it){
		val evBufs = eventBuffersTypes(newArrayList)
		features += evBufs
		evBuf
	}
	
	def createClearInEvents(ComplexType smClass){
		val inEvents = smClass.eAllContents.filter(Property).filter[(origin instanceof Event) && (origin as Event).isInEvent].toList
		val timeEvents = smClass.eAllContents.filter(Property).filter[(origin instanceof ArrayList) && (origin as ArrayList).exists[it instanceof TimeEvent]].head
		_op(CLEAR_IN_EVENTS,_void) => [
			val eventBlock = _block(
				inEvents.filter(AnnotatableElement).filter[!isEvent].map[ i |
					if(i.eContainer.isCsharpInterface){
						i.stateMachineClass.features.filter(ComplexType).filter[
							superTypes.head?.type === i.eContainer
						].head.features.filter(Part).head._ref._dot(i)._assignment(_false)
					} else {
						i._ref._assignment(_false)
					}
				]
			)
			if(timeEvents !== null){
				for (var i = 0; i < (timeEvents.typeSpecifier as ArrayTypeSpecifier).size; i++) {
					eventBlock.expressions += timeEvents._ref_array(i._integer)._assignment(_false)
				}
			}
			implementation = eventBlock		
			_private
			generateDefinitionWith[methodDefinitionCode]
		]
	}
	
	def dispatch getStatemachineEventValue(Object e, ComplexType smClass){}
	
	def protected substitueMethodMember(Declaration method, ComplexType smClass){
		method.eAllContents
			.filter(ArgumentExpression)
			.toList
			.forEach[source |
				val target = smClass.eAllContents.filter(Declaration).filter[c |
					c.origin !== null &&
					source.featureOrReference !== null &&
					c.origin === source.featureOrReference
				].head
				if(target !== null)
					EcoreUtil.replace(source, source.replaceSource(target))						
			]		
	}
	
	def protected substitueEvBufInExecFlow(Declaration exec, ComplexType evBufClass){
		exec.eAllContents
			.filter(ArgumentExpression)
			.toList
			.forEach[source |
				val target = evBufClass.eAllContents.filter(Declaration).filter[c |
					c.origin !== null &&
					source.featureOrReference !== null &&
					c.origin === source.featureOrReference
				].head
				if(target !== null){
					if(source instanceof FeatureCall)
						source.feature = target
					else if(source instanceof ElementReferenceExpression)
						source.reference = target
				}
			]		
	}
	
	def protected addExprForEventValueAssignement(Operation method, ComplexType smClass){
		method.eAllContents
			.filter(FeatureCall)
			.filter[
				val ref=featureOrReference
				if(ref instanceof Event){
					if(ref !== null && ref.hasValue || ref.hasMetaValue)
						return true
					else false
				} else false
			]
			.forEach[ e |
				val smEvValue = e.featureOrReference.getStatemachineEventValue(smClass)
				(method.implementation as BlockExpression).expressions += _assignment(
					e.copy => [
						feature = smEvValue.getEventBufferEventValue(smClass)
					],
					if(smEvValue.eContainer !== smEvValue.stateMachineClass)
						(smEvValue.eContainer as ComplexType).features.filter(Part).head._ref._dot(smEvValue)
					else
						smEvValue._ref
				)	
			]		
	}
	
	def protected dispatch ArgumentExpression replaceSource(ElementReferenceExpression it, Declaration refer) {
		//Add Iface access if necessary
		if(it.reference instanceof Event && refer.eContainer !== refer.stateMachineClass)
			return refer.stateMachineClass.eAllContents.filter(Part).filter[type === refer.eContainer].head._ref._dot(refer)
		it.copy => [e |
			if(refer instanceof ComplexType)
				e.reference = refer.features.filter[p | p.name === (reference as NamedElement).name].head
			else
				e.reference = refer
		]
	}
	
	def protected dispatch ArgumentExpression replaceSource(FeatureCall it, Declaration refer) {
		it.copy => [
			if(owner instanceof FeatureCall) owner = (owner as FeatureCall).swapOwners(refer)
			feature = refer
		]
	}
	
	def FeatureCall swapOwners(FeatureCall it, Declaration refer){
		it.copy => [
			if(owner instanceof FeatureCall){
				feature = (refer.eContainer.eContainer as ComplexType).features.filter[p | p.name === (feature as NamedElement).name].head
				owner = (owner as FeatureCall).swapOwners(refer.eContainer as Declaration)
			}
			else if(owner instanceof ElementReferenceExpression){
				feature = (refer.eContainer.eContainer as ComplexType).features.filter[p | p.name === (feature as NamedElement).name].head
				owner = (owner as ElementReferenceExpression).replaceSource(refer.eContainer.eContainer.eContainer as Declaration)				
			}
		]
	}
		
}