/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.transformation

import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Operation
import com.google.inject.Inject
import com.yakindu.base.types.TypeBuilder

/**
 * If no return type is specified for operations then the void type is assumed.
 * This modification will assign the void as return type to all operations without return type specifier.
 * 
 * Code models must contain a complete type specification for proper code generation.
 * 
 * @author Axel Terfloth
 */
class VoidIsDefaultReturnTypeModification {
	
	@Inject protected extension TypeBuilder
	
	def <T extends Declaration> T useVoidAsDefaultReturnType(T it) {
		it.eAllContents
			.filter(Operation)
			.forEach [ op |
				if (op.typeSpecifier === null){
					op.typeSpecifier = _typeSpecifier(_void)
				}
			]
		
		return it
	}
}