/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.itemis.create.base.generator.core.concepts.InternallyDefinedTypeAnnotation
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.model.sexec.extensions.SExecExtensions

/**
 * 
 * This concept is responsible to create and serve the Parent object whenever it is needed.
 * The parent object is required in named interface scenarios, when the named interface requires
 * linkage to it's parent due to required shared objects (e.g. event queue, semaphore)
 * 
 * @author laszlo kovacs - Initial contribution
 *
 */
 //TODO: The generalization of the class should be re-evaluated. Although should be fine as it is for any OOP language.
@Singleton
class InterfaceContext {
	
	//TODO: The "Parent" name should be re-evaluated (e.g. "context")
	public static String PARENT = "parent"
	
	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	@Inject protected extension TypeBuilder
	@Inject protected extension StatemachineClass
	@Inject protected extension InternallyDefinedTypeAnnotation
	@Inject protected extension OriginTracing
	@Inject protected extension GeneratorAssignment
	@Inject protected extension IVariableCode
	@Inject protected extension SExecExtensions
	@Inject protected extension NamedInterfaceClasses
	@Inject protected extension VisibilityAnnotations
	
	def create it : _variable(PARENT, ifaceType.stateMachineClass) defineParentForIface(ComplexType ifaceType){
		_internallyDefinedType
		traceOrigin(PARENT)
		generateDeclarationWith[ variableDeclarationCode ]
		_private
	}
	
	def parentForIface(ComplexType it){
		_createCache_defineParentForIface.get(#[it])
	}
	
	def needsParent(TypedDeclaration e){
		val parent = e.scope?.namedInterfaceClass?.parentForIface
		if(parent !== null)
			true
		else
			false
	}
	
	def parentFor(TypedDeclaration e){
		e.scope?.namedInterfaceClass?.parentForIface
	}
	
	def ifaceConstructor(ComplexType ifaceType){
		val parent = ifaceType.defineParentForIface
		ifaceType.features += parent
		ifaceType.features += _op(ifaceType.name) => [
			_public
			val param = createParameter => [
				name = PARENT
				typeSpecifier = createTypeSpecifier => [ ts |
					ts.type = ifaceType.stateMachineClass
				]
			]
			parameters += param
			generateDefinitionWith[ '''
					«visibility.visibilityName» «name»(«param.type» «param.name»){
						this.«parent.name» = «param.name»;
					}
				''' ]	
		]
	}
}