package com.yakindu.sct.generator.core.concepts

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.concepts.Documentation
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Event
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.base.types.typesystem.ITypeValueProvider
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.EcoreUtil

@Singleton
class EventMembers {
	
	@Inject protected extension TypeBuilder
	@Inject protected extension ITypeValueProvider
	@Inject protected extension ExpressionBuilder
	@Inject protected extension SExecExtensions
	@Inject protected extension OriginTracing
	@Inject protected extension Documentation
	@Inject protected extension NamedInterfaceClasses
	
	/** 
	 * This methods defines an event raised flag for an event and adds it as a sibling.
	 */
	def create r : _variable(e.raised, _boolean ) defineEventRaisedFlag(TypedDeclaration e) {
		
		r.traceOrigin(e)
		r.documentation('''Indicates event '«e.name»' of «e.scope.scopeDescription» is active.''')
		r._private
		r.initialValue = _false
		
		e.scope.scopeClass.features += r
	
	}
	
	/** 
	 * This methods defines an event value member for an event and adds it as a sibling.
	 */
	def create r :  _variable(e.value, EcoreUtil.copy(e.typeSpecifier)) defineEventValueMember(TypedDeclaration e) {
		val defVal = r.typeSpecifier.type.defaultValue
		r.initialValue = defVal === null ? null :  defVal._value
		r.documentation('''Value of event '«e.name»' of «e.scope.scopeDescription».''')
		r._private
				
		e.scope.scopeClass.features += r
	}
	
	/** 
	 * Defines an event raised flag for each incoming event defined by this complex type.
	 */
	def void defineEventRaisedFlag(EObject it) {
		eAllContents
			.filter(Event)
			.filter[ direction === Direction.IN ]
			.toList
			.forEach[ defineEventRaisedFlag ]	
	}
	
	/** 
	 * Defines an event value member for each incoming event defined by this complex type.
	 */
	def void defineEventValueMember(EObject it) {
		eAllContents
			.filter(Event)
			.filter[ direction === Direction.IN ]
			.filter[type !== null && type.name != 'void']
			.toList
			.forEach[ defineEventValueMember ]	
	}
	
	/**
	 * Returns the event raised flag for an event if it is defined or null if it is not defined yet.
	 */
	def eventRaisedFlagType(TypedDeclaration it) {
		_createCache_defineEventRaisedFlag.get(#[it])	
	}
	
	/**
	 * Returns the event value member for an event if it is defined or null if it is not defined yet.
	 */
	def eventValueMemberType(TypedDeclaration it) {
		_createCache_defineEventValueMember.get(#[it])	
	}
	
	def value(TypedDeclaration it) { it.name + 'Value' }
	def raised(TypedDeclaration it) { it.name + 'Raised' }
}