/**
 * Copyright (c) 2024-2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.extensions

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Property
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope

class EventQueueExtension {
	
	public static final String INCOMING_EVENT_QUEUE_NAME= "incomingEventQueue"
	public static final String INTERNAL_EVENT_QUEUE_NAME= "internalEventQueue"
	public static final String GET_NEXT_EVENT_METHOD_NAME= "getNextEvent"
	public static final String DISPATCH_EVENT_METHOD_NAME= "dispatchEvent"
	public static final String GET_TIME_EVENT_ID_METHOD_NAME= "getTimeEventId"
	
	@Inject protected extension EventQueue
	@Inject protected extension StatemachineClass
	
	def eventsHandledByStatemachineClass(ExecutionFlow flow) {
		flow
			.scopes
			.filter[ (it instanceof InterfaceScope 
						&& ((it as InterfaceScope)?.name.isNullOrEmpty) && flow.requiresIncomingEventQueue)
					  ||
					   it instanceof InternalScope ]
			.map[ members.filter(EventDefinition).filter[ direction !== Direction.OUT ].toList ]
			.flatten
			.toList
	}
	
	def internalEventQueue(ExecutionFlow it) {
		stateMachineClass.features.filter(Property).filter[ name.toLowerCase == INTERNAL_EVENT_QUEUE_NAME.toLowerCase ].head
	}
	
	def dispatch Property incomingEventQueue(ExecutionFlow it) {
		stateMachineClass.incomingEventQueue
	}
	
	def dispatch Property incomingEventQueue(ComplexType it) {
		features.filter(Property).filter[ name.toLowerCase == INCOMING_EVENT_QUEUE_NAME.toLowerCase ].head
	}
	
	def dispatchEventMethod(ExecutionFlow it) {
		stateMachineClass.features.filter(Operation).filter[name.toLowerCase == DISPATCH_EVENT_METHOD_NAME.toLowerCase].head
	}
	
	def nextEventMethod(ExecutionFlow it) {
		stateMachineClass.features.filter(Operation).filter[name.toLowerCase == GET_NEXT_EVENT_METHOD_NAME.toLowerCase].head
	}
	
	def getTimeEventMethod(ExecutionFlow it) {
		stateMachineClass.features.filter(Operation).filter[name.toLowerCase == GET_TIME_EVENT_ID_METHOD_NAME.toLowerCase].head
	}
}