/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.library.impl

import com.yakindu.sct.generator.core.library.AbstractFeatureTypeLibraryProvider
import static com.yakindu.base.types.typesystem.ITypeSystem.*
import static com.yakindu.sct.generator.core.library.ICoreLibraryConstants.*

class CoreFeatureTypeLibraryProvider extends AbstractFeatureTypeLibraryProvider {

	def outlet() {
		createFeatureType => [
			name = "Outlet"
			parameters += createFeatureParameter => [
				name = "targetProject"
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "targetFolder"
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "libraryTargetFolder"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "skipLibraryFiles"
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}

	def licenseHeader() {
		createFeatureType => [
			name = "LicenseHeader"
			optional = true
			parameters += createFeatureParameter => [
				name = "licenseText"
				parameterType = getType(STRING)
			]
		]
	}

	def debug() {
		createFeatureType => [
			name = "Debug"
			optional = true
			parameters += createFeatureParameter => [
				name = "dumpSexec"
				parameterType = getType(BOOLEAN)
			]
			//TODO: Enable when ALL target languages support the feature
			/* Debug generator feature is not publicly available yet ...  */
//			parameters += createFeatureParameter => [
//				name = DEBUG_FEATURE_DEBUG_EXECUTION
//				parameterType = getType(BOOLEAN)
//			]
			/* Debug generator feature is not publicly available yet ...  */
		]
	}

	def functionInlining() {
		createFeatureType => [
			name = "FunctionInlining"
			optional = true
			parameters += createFeatureParameter => [
				name = "inlineReactions"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineEntryActions"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineExitActions"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineEnterSequences"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineExitSequences"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineChoices"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineEnterRegion"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineExitRegion"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineEntries"
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}

	def outEventAPI() {
		createFeatureType => [
			name = "OutEventAPI"
			optional = true
			parameters += createFeatureParameter => [
				name = "observables"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "getters"
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}

	override provide() {
		createFeatureTypeLibrary => [
			name = "Core"
			types += outlet()
			types += licenseHeader()
			types += debug()
			types += functionInlining()
			types += outEventAPI()
		]
	}
}
