/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.templates

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.base.base.NamedElement
import com.yakindu.sct.generator.core.submodules.lifecycle.NamedConceptSequenceCode
import com.yakindu.sct.model.sexec.Execution
import com.yakindu.sct.model.sexec.LocalVariableDefinition
import com.yakindu.sct.model.sexec.Reaction
import com.yakindu.sct.model.sexec.Sequence
import com.yakindu.sct.model.sexec.Statement
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.Trace
import com.yakindu.sct.model.sexec.concepts.StateMachineBehaviorConcept
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.itemis.create.base.generator.core.codepattern.TypeSystemAccessExpressionCode

/**
 * @author Axel Terfloth
 */
class SexecGenerator {
	
	@Inject protected extension SExecExtensions
	@Inject protected extension TypeSystemAccessExpressionCode
	@Inject protected extension TraceCodeGenerator 
	@Inject protected extension NamedConceptSequenceCode
	@Inject protected extension StateMachineBehaviorConcept
	@Inject protected extension ICodegenTypeSystemAccess
	


	def dispatch code(NamedElement it) '''
		// ERROR: Can't generate code for '«getClass().name»'
	'''

	def dispatch CharSequence code(Reaction it) {
		effect.code
	}

	def dispatch CharSequence code(Execution it) '''
		«statement.statement»
		«statement.traceCode»
		'''

	def dispatch CharSequence code(LocalVariableDefinition it) '''
		«variable.typeSpecifier.targetLanguageName» «variable.name»«IF initialValue !== null» = «initialValue.code»«ENDIF»;
	'''


	def dispatch CharSequence code(Sequence it) {
		if (it.isStateMachineConcept) 
			it.flow.stateMachineConceptCode(it)	
		else '''
			«IF !steps.nullOrEmpty»«stepComment»«ENDIF»
			«FOR s : steps»
				«s.code»
			«ENDFOR»
		'''
	}


	def dispatch CharSequence code(Statement it) '''
		«expression.statement»
		«expression.traceCode»
	'''

	def dispatch CharSequence code(Trace it) {
		traceCode
	}
		

	def stepComment(Step it) '''
		«IF !comment.nullOrEmpty»
			/* «comment» */
		«ENDIF»
	'''
	
}