/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sctunit.generator.python.extensions

import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions
import org.eclipse.emf.ecore.EObject
import com.yakindu.base.types.Parameter
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass

class PythonNavigationExtension extends BaseNavigationExtensions{
	override isLocal(EObject e) {
		super.isLocal(e) || e instanceof Parameter
	}
	
	def isGlobalVar(EObject o) {
		if(o instanceof VariableDefinition && o.eContainer instanceof VariableDefinitionStatement) {
			val stm = o.eContainer as VariableDefinitionStatement
			return stm.eContainer instanceof SCTUnitClass
		}
		return false
	}
}