/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
 package com.yakindu.sct.model.sexec.concepts

import com.google.inject.Inject
import com.itemis.create.base.model.bindings.BindingsTypeLibrary
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.EventSpec
import com.yakindu.base.expressions.expressions.ReactionEffect
import com.yakindu.base.expressions.expressions.ReactionTrigger
import com.yakindu.base.expressions.expressions.RegularEventSpec
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.InternalScope
import org.eclipse.emf.ecore.util.EcoreUtil
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Expression
import com.yakindu.base.expressions.expressions.BlockExpression
import java.util.ArrayList
import com.google.inject.Singleton

/**
 * Defines the onInit concept. it provides a pseudo event 'onInit' which users can use to initialize bindings 
 * and other aspects of a statechart. 
 * 
 * TODO: refactor in two parts - one only dependent on types and the second specific for statecharts.
 * 
 * @author axel terfloth
 */
@Singleton
class OnInitHook {
	
	public static val ON_INIT_HOOK_NAME = "_" + BindingsTypeLibrary.ON_INIT_EVENT_NAME + "Hook"
	public static val ON_INIT_DONE_NAME = "_" + BindingsTypeLibrary.ON_INIT_EVENT_NAME + "Done"
	
	@Inject protected extension ExpressionExtensions
	@Inject protected extension BindingsTypeLibrary
	@Inject protected extension SExecExtensions
	@Inject protected extension TypeBuilder
	@Inject protected extension ExpressionBuilder
	
	def defineFeatures(ExecutionFlow it) {
		if (appliesOnInitHook) {
			defineOnInitDone
			defineOnInitHook
		}
	}
	
	def addOnInitAction(ExecutionFlow it, Expression exp) {
		defineOnInitHook => [
			val body = implementation as BlockExpression
			body.expressions.add(0, exp)
		]
	}
	
	def protected appliesOnInitHook(ExecutionFlow it) {
		statechart.onInitReaction !== null
	}
	
	def protected create oih : ON_INIT_HOOK_NAME._op(_void) defineOnInitHook(ExecutionFlow flow) {
		oih => [
			_public
			
			val effect = flow.statechart.onInitReaction?.effect
			val actions = switch (effect) {
				ReactionEffect : EcoreUtil.copyAll(effect.actions)
				default : new ArrayList
			}
			actions += flow.defineOnInitDone._ref._assign(_true)
			implementation = _block( actions )	 
			flow.features += it
		]
	}
	
	def onInitHook(ExecutionFlow it) {
		features.filter(Operation).filter( m | m.name == ON_INIT_HOOK_NAME).head		
	}
	
	def hasOnInitHook(ExecutionFlow it) {
		onInitHook !== null
	}
	
	def protected create f : _variable(ON_INIT_DONE_NAME, _boolean, _false) defineOnInitDone(ExecutionFlow it) {
		f._synthetic
		it.features += f
	}
	
	def onInitDone(ExecutionFlow it) {
		features.filter(com.yakindu.base.types.Property).filter( m | m.name == ON_INIT_DONE_NAME).head		
	}
	
	def hasOnInitDone(ExecutionFlow it) {
		onInitDone !== null
	}
	
	def _callOnInitHook(ExecutionFlow it) {
		if (hasOnInitHook && hasOnInitDone)
			_if (onInitDone._ref._not)
			._then(onInitHook._call)
		else
			_block
	}
	
	
	def protected onInitReaction(Statechart it) {
		scopes
			.filter(InternalScope)
			.map[
				reactions
			]
			.flatten
			.findFirst[
				val t = trigger
				if (t instanceof ReactionTrigger) {
					if (t.triggers.size == 1) {
						val es = t.triggers.head
						if (es instanceof RegularEventSpec) {
							if (es.isOnInit)
								return true
						}
					}
				}
				return false
			]
		
	}
	
	def isOnInit(EventSpec it) {
		if (it instanceof RegularEventSpec) {
			it.event.featureOrReference.isOnInitEvent
		}
	}
}