/**
 * Copyright (c) 2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.concepts

import com.google.inject.Inject
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.model.sexec.ExecutionFlow

import static com.itemis.create.base.model.core.ConceptModel.*
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.BlockExpression

/**
 * Defines a 'onUpdateState' hook which supports adding state updates to the 
 * RTCS execution. It supports adding state update behavior to the run cycle. 
 * This hook will be called after each micro step.
 * 
 * Example use cases are binder updates for elements which are not actively triggered 
 * using observables.
 * 
 * @author axel terfloth - initial contribution
 */
class OnUpdateStateHook {
	
	public static String ON_UPDATE_STATE = "onUpdateState"
	
	@Inject extension TypeBuilder
	@Inject extension ExpressionBuilder
	
	/**
	 * Definition of the onUpdateSatet concept.
	 */
	protected var onUpdateStateConcept = featureConcept(ExecutionFlow, Operation, ON_UPDATE_STATE, [
		_op(ON_UPDATE_STATE, _void) => [
			_protected
			_body(_block)
		]
	])
	
	def onUpdateStateHook(ExecutionFlow it) {
		onUpdateStateConcept.definition(it)
	}
	
	def hasOnUpdateStateHook(ExecutionFlow it) {
		onUpdateStateHook !== null
	}
	
	/**
	 * Adds behavior defined as an expression to the onUpdateState hook. 
	 */
	def void addOnUpdateStateBehavior(ExecutionFlow it, Expression behavior) {
		if (behavior !== null) {
			val onUpdateStateBody = onUpdateStateConcept.define(it).implementation
			if (onUpdateStateBody instanceof BlockExpression) {
				onUpdateStateBody.expressions += behavior
			}
		}
	}
}