/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.concepts

import com.google.inject.Inject
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.extensions.SexecBuilder
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations

/**
 * This class defines the concept of super steps processing.
 *  
 * @author aterfloth
 */
class SuperStep {
	
	@Inject extension TypeBuilder
	@Inject extension ExpressionBuilder
	@Inject extension SexecBuilder
	@Inject extension StatechartAnnotations
	@Inject extension HaltBehavior
	@Inject extension SubMachine
	

	public static val String STATE_CHANGED = "stateConfVectorChanged"
	
	
	def void defineFeatures (ExecutionFlow it) {
		if (appliesSuperStep || appliesSubMachine) 
			it.features += _variable(STATE_CHANGED, _boolean) => [
				_synthetic
			]
	}
	
	def Step _superStepLoop(ExecutionFlow it, Step body) {
		
		if (appliesSuperStep)
			_do( _sequence(
				stateChangedProperty._assign(_false),
				body
			))
			._while(
				stateChangedProperty._ref
					._andIsNotHalted(it)
			)
		else 
			body
	}
	
	def Expression _superStepLoop(ExecutionFlow it, Expression body) {
		
		if (appliesSuperStep)
			_block(
				stateChangedProperty._ref._assign(_true),
				stateChangedProperty._ref
						._andIsNotHalted(it)	
				._while(
					_block(	
						stateChangedProperty._ref._assign(_false),
						body
					)
				)
			)
		else 
			body
	}
	
	def _stateChanged(ExecutionFlow it) {
		if (stateChangedProperty !== null) 
			stateChangedProperty._assign(_true)
		else
			_empty
	}	
	
	def Property stateChangedProperty(ExecutionFlow it) {
		features.filter(Property).filter( m | m.name == STATE_CHANGED).head
	}
	
	
	def appliesSuperStep(ExecutionFlow it) {
		(it.sourceElement as Statechart).isSuperStep
	}
}