/**
 * Copyright (c) 2020-2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.transformation

import com.google.inject.Inject
import com.google.inject.name.Named
import com.yakindu.sct.model.sexec.ExecutionNode
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.Reaction
import com.yakindu.sct.model.sexec.Sequence
import com.yakindu.sct.model.sexec.Trace

class TraceExtensions {
	
	@Inject extension SexecFactoryExtensions sexec

	@Inject(optional = true)
	@Named(IModelSequencer.ADD_TRACES) 
	boolean _addTraceSteps = false
	
	def isAddTraceSteps() {
		_addTraceSteps
	}
	
	def Sequence _trace(Sequence sequence, Reaction it) {
		if (addTraceSteps) {
			sequence.steps.add(0, it._traceReactionWillFire)
			sequence.steps.add(it._traceReactionFired)
		}
		
		return sequence
	}
	
	def Sequence _trace(Sequence sequence, ExecutionNode it) {
		if (addTraceSteps) {
			sequence.steps.add(0, it._traceNodeExecuted)
		}
		
		return sequence
	}
	
	
	def Sequence _trace(Sequence sequence, Trace trace) {
		if (addTraceSteps && sequence !== null && trace !== null) {
			sequence.steps += trace
		}
		
		return sequence
	}
	
	
	def Sequence _traceBefore(Sequence sequence, Trace trace) {
		if (addTraceSteps && sequence !== null && trace !== null) {
			sequence.steps.add(0,trace)
		}
		
		return sequence
	}
	
	
	def _traceReactionFired(Reaction r) {
		val rf = sexec.factory.createReactionFired
		rf.reaction = r
		rf
	}


	def _traceReactionWillFire(Reaction r) {
		val rf = sexec.factory.createTraceReactionWillFire
		rf.reaction = r
		rf
	}
	
	def _traceNodeExecuted(ExecutionNode node) {
		val t = sexec.factory.createTraceNodeExecuted
		t.node = node
		t
	}
	
	
	def _traceStateEntered(ExecutionState state) {
		val t = sexec.factory.createTraceStateEntered
		t.state = state
		t
	}
	
	def _traceStateExited(ExecutionState state) {
		val t = sexec.factory.createTraceStateExited
		t.state = state
		t
	}

	 
}