/** 
 * Copyright (c) 2022-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Contributors:
 * Andreas Muelder - itemis AG
 */
package com.yakindu.sctunit.ui.outline

import org.eclipse.emf.common.util.EList
import org.eclipse.emf.ecore.EObject
import org.eclipse.swt.graphics.Image
import org.eclipse.xtext.EcoreUtil2
import org.eclipse.xtext.ui.editor.outline.IOutlineNode
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Expression
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitElement
import com.yakindu.sctunit.sCTUnit.TestPackage
import com.yakindu.sctunit.sCTUnit.TestStatement
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement

/** 
 * customization of the default outline structure
 * @author oliver bohl
 */
class SCTUnitOutlineTreeProvider extends DefaultOutlineTreeProvider {
	override protected void _createChildren(DocumentRootNode parentNode, EObject modelElement) {
		if (modelElement instanceof TestPackage) {
			val element = EcoreUtil2.getAllContentsOfType(((modelElement as TestPackage)), SCTUnitElement).head
			if(element !== null) 
				createNode(parentNode, element)
		}
	}

	override protected void _createChildren(IOutlineNode parentNode, EObject modelElement) {
		if (modelElement instanceof SCTUnitClass) {
			var SCTUnitClass sctUnitClass = (modelElement as SCTUnitClass)
			for (VariableDefinitionStatement ^var : sctUnitClass.getVariableDefinitions()) {
				_createNode(parentNode, ^var)
			}
			for (Declaration decl : sctUnitClass.getFeatures()) {
				_createNode(parentNode, decl)
			}
		} else {
			super._createChildren(parentNode, modelElement)
		}
	}

	override protected void _createNode(IOutlineNode parentNode, EObject modelElement) {
		var Object text = textDispatcher.invoke(modelElement)
		if (modelElement instanceof VariableDefinitionStatement) {
			var VariableDefinitionStatement variableDefinitionStatement = (modelElement as VariableDefinitionStatement)
			text = variableDefinitionStatement.getDefinition().getName()
		}
		var boolean isLeaf = true
		var EList<EObject> content = modelElement.eContents()
		for (EObject childElement : content) {
			if(childElement instanceof TestStatement) isLeaf = false
		}
		var Image image = imageDispatcher.invoke(modelElement)
		if (!(modelElement instanceof Expression)) {
			createEObjectNode(parentNode, modelElement, image, text, isLeaf)
		}
	}
}
